/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.faq.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.util.MessageType;
import com.arsdigita.util.Assert;
import com.arsdigita.util.StringUtils;

import com.arsdigita.faq.Faq;
import com.arsdigita.web.Application;
import com.arsdigita.faq.ApplicationAuthenticationListener;
import com.arsdigita.faq.ui.FaqBasePage;

import java.math.BigDecimal;


/**
 * FaqPage is the base Bebop page for the Faq package.
 *
 * It includes a common header, a footer, and a main "content"
 * area. Components are added to the main content area.
 *
 * FaqPage also contains static utility methods used by the
 * throughout the FAQ package.
 *
 * @author <a href="mailto:teadams@arsdigita.com">Tracy Adams</a>
 * @version $Revision: #3 $ $Date: 2003/08/15 $
 */

public class FaqPage extends FaqBasePage {

    public static final String versionId = "$Id: //apps/faq/dev/src/com/arsdigita/faq/ui/FaqPage.java#3 $ by $Author: dennis $, $DateTime: 2003/08/15 13:46:34 $";

    private static final org.apache.log4j.Logger log =
        org.apache.log4j.Logger.getLogger(FaqPage.class);

    public static final String FAQ_XML_NS = "http://www.arsdigita.com/faq/1.0";

    private SingleSelectionModel m_questionSelection;

    public FaqPage() {
        this("user");
    }

    public FaqPage(String view) {
        super(view);
        if ( view.equals("admin") ) {
            addRequestListener(new ApplicationAuthenticationListener("admin"));
        }
    }

    void setQuestionSelectionModel(SingleSelectionModel selection) {
        m_questionSelection = selection;
    }

    BigDecimal getQuestionID(PageState s) {
        String key = (String) m_questionSelection.getSelectedKey(s);
        if (StringUtils.emptyString(key)) {
            return null;
        } else {
            return new BigDecimal(key);
        }
    }

    /**
     *
     * gets the ID of the selected faq. If no faq is selected,
     * it returns null
     *
     * @return the BigDecimal ID of the faq or null if none is selected
     */

    public BigDecimal getFaqID(PageState state) {
        Faq faq = getFaq(state);
        Assert.assertNotNull(faq, "faq");
        return faq.getID();
    }

    public Faq getFaq(PageState state) {
        return (Faq)Application.getCurrentApplication(state.getRequest());
    }

    /** Returns HTML text, converted from the following:
     *  HTML -- returns the input
     *  pre-formatted - returns the input wrapped in <pre> tags
     *  plain - returns the input converted to HTML.
     */

    public static String generateHTMLText(String text, String formatType) {
        if (text == null) {
            return "";
        }
        if (formatType.equals(MessageType.TEXT_HTML)) {
            return text;
        } else if (formatType.equals(MessageType.TEXT_PREFORMATTED)) {
            return "<pre>"+text+"</pre>";
        } else {
            /*format is plain*/
            return StringUtils.textToHtml(text);
        }
    }
}
