/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.faq.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.ModalContainer;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.ToggleLink;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.faq.QAPair;
import com.arsdigita.faq.ui.AdminQuestionTable;
import com.arsdigita.faq.ui.AdminQuestionView;
import com.arsdigita.faq.ui.FaqPage;
import com.arsdigita.faq.ui.FaqQuestionEntryForm;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.IOException;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class AdminQuestionsPane
extends ModalContainer
implements ActionListener {
    public static final String versionId = "$Id: //apps/faq/dev/src/com/arsdigita/faq/ui/AdminQuestionsPane.java#2 $$Author: dennis $$DateTime: 2003/08/15 13:46:34 $";
    private Container m_questions = new SimpleContainer();
    private ToggleLink m_newLink;
    private AdminQuestionView m_questionView;
    private FaqQuestionEntryForm m_editForm;
    private SingleSelectionModel m_selection;

    public AdminQuestionsPane() {
        AdminQuestionTable questionsTable = new AdminQuestionTable(new AdminQuestionTable.QuestionModelBuilder());
        this.m_selection = questionsTable.getRowSelectionModel();
        this.m_questions.add((Component)questionsTable);
        this.m_newLink = new ToggleLink("Add a new question");
        this.m_questions.add((Component)this.m_newLink);
        this.add((Component)this.m_questions);
        this.setDefaultComponent((Component)this.m_questions);
        this.m_questionView = new AdminQuestionView(this.m_selection);
        this.add((Component)this.m_questionView);
        this.m_editForm = new FaqQuestionEntryForm();
        this.m_editForm.addCompletionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState s = e.getPageState();
                if (AdminQuestionsPane.this.m_selection.isSelected(s)) {
                    AdminQuestionsPane.this.m_questionView.getEditLink().setSelected(s, false);
                    AdminQuestionsPane.this.setVisibleComponent(s, (Component)AdminQuestionsPane.this.m_questionView);
                } else {
                    AdminQuestionsPane.this.m_newLink.setSelected(s, false);
                    AdminQuestionsPane.this.setVisibleComponent(s, (Component)AdminQuestionsPane.this.m_questions);
                }
            }
        });
        this.add((Component)this.m_editForm);
    }

    public void register(Page p) {
        super.register(p);
        p.addActionListener((ActionListener)this);
        ((FaqPage)p).setQuestionSelectionModel(this.m_selection);
    }

    public void actionPerformed(ActionEvent e) {
        PageState s = e.getPageState();
        if (this.m_selection.isSelected(s)) {
            this.redirectWhenNotFound(s);
            if (this.m_questionView.getEditLink().isSelected(s)) {
                this.setVisibleComponent(s, (Component)this.m_editForm);
            } else {
                this.setVisibleComponent(s, (Component)this.m_questionView);
            }
        } else if (this.m_newLink.isSelected(s)) {
            this.setVisibleComponent(s, (Component)this.m_editForm);
        } else {
            this.setVisibleComponent(s, (Component)this.m_questions);
        }
    }

    private void redirectWhenNotFound(PageState state) {
        BigDecimal id = new BigDecimal((String)this.m_selection.getSelectedKey(state));
        try {
            QAPair pair = new QAPair(id);
        }
        catch (DataObjectNotFoundException nfe) {
            try {
                DispatcherHelper.sendRedirect((HttpServletRequest)state.getRequest(), (HttpServletResponse)state.getResponse(), (String)"/error/object-not-found.jsp");
            }
            catch (IOException ioe) {
                throw new UncheckedWrapperException((Throwable)ioe);
            }
        }
    }
}

