/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.faq;

import com.arsdigita.dispatcher.ObjectNotFoundException;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.faq.Faq;
import com.arsdigita.faq.QAPair;
import com.arsdigita.faq.ui.FaqQuestionsPortlet;
import com.arsdigita.initializer.Configuration;
import com.arsdigita.initializer.InitializationException;
import com.arsdigita.kernel.ACSObjectInstantiator;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.NoValidURLException;
import com.arsdigita.kernel.PackageType;
import com.arsdigita.kernel.Stylesheet;
import com.arsdigita.kernel.URLFinder;
import com.arsdigita.kernel.URLService;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.portal.apportlet.AppPortletType;
import com.arsdigita.web.Application;
import com.arsdigita.web.ApplicationType;
import org.apache.log4j.Logger;

public class Initializer
implements com.arsdigita.initializer.Initializer {
    private Configuration m_conf = new Configuration();
    public static final String versionId = "$Id: //apps/faq/dev/src/com/arsdigita/faq/Initializer.java#7 $ by $Author: scott $, $DateTime: 2004/01/20 11:45:10 $";
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$faq$Initializer == null ? (class$com$arsdigita$faq$Initializer = Initializer.class$("com.arsdigita.faq.Initializer")) : class$com$arsdigita$faq$Initializer));
    static /* synthetic */ Class class$com$arsdigita$faq$Initializer;

    public Configuration getConfiguration() {
        return this.m_conf;
    }

    public void startup() {
        s_log.info((Object)"Faq Initializer starting.");
        TransactionContext txn = SessionManager.getSession().getTransactionContext();
        txn.beginTxn();
        ACSObjectInstantiator instantiator = new ACSObjectInstantiator(){

            protected DomainObject doNewInstance(DataObject dataObject) {
                return new Faq(dataObject);
            }
        };
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.faq.Faq", (DomainObjectInstantiator)instantiator);
        this.checkFaqSetup();
        instantiator = new ACSObjectInstantiator(){

            protected DomainObject doNewInstance(DataObject dataObject) {
                return new FaqQuestionsPortlet(dataObject);
            }
        };
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.faq.FaqQuestionsPortlet", (DomainObjectInstantiator)instantiator);
        txn.commitTxn();
        URLFinder faqFinder = new URLFinder(){

            public String find(OID oid, String context) throws NoValidURLException {
                return this.find(oid);
            }

            public String find(OID oid) throws NoValidURLException {
                QAPair pair;
                try {
                    pair = (QAPair)DomainObjectFactory.newInstance((OID)oid);
                }
                catch (DataObjectNotFoundException e) {
                    throw new ObjectNotFoundException("No such FAQ item: " + oid + " .may have been deleted.");
                }
                String url = pair.getFaq().getPrimaryURL() + "#" + pair.getID();
                return url;
            }
        };
        URLService.registerFinder((String)"com.arsdigita.faq.QAPair", (URLFinder)faqFinder);
        s_log.debug((Object)"Faq Initializer done.");
    }

    private void checkFaqSetup() {
        try {
            s_log.debug((Object)"Faq Initializer - verifying setup.");
            PackageType FaqType = PackageType.findByKey((String)"faq");
        }
        catch (DataObjectNotFoundException e) {
            this.setupFaq();
        }
    }

    private void setupFaq() {
        s_log.info((Object)"Faq Initializer - setting up new package");
        PackageType FaqType = PackageType.create((String)"faq", (String)"FAQ ", (String)"FAQ s", (String)"http://arsdigita.com/faq");
        s_log.debug((Object)"Just added package type FAQ ");
        Stylesheet FaqSheet = Stylesheet.createStylesheet((String)"/packages/faq/xsl/faq.xsl");
        FaqType.addStylesheet(FaqSheet);
        FaqType.setDispatcherClass("com.arsdigita.faq.FaqDispatcher");
        FaqType.save();
        final ApplicationType faqAppType = ApplicationType.createApplicationType((PackageType)FaqType, (String)"FAQ Application", (String)"com.arsdigita.faq.Faq");
        faqAppType.save();
        KernelExcursion ex = new KernelExcursion(){

            protected void excurse() {
                this.setParty(Kernel.getSystemParty());
                Application faqApp = Application.createApplication((ApplicationType)faqAppType, (String)"faq", (String)"FAQ", null);
                faqApp.save();
            }
        };
        ex.run();
        AppPortletType portletType = AppPortletType.createAppPortletType((String)"Faq Questions Portlet", (String)"wide", (String)"com.arsdigita.faq.FaqQuestionsPortlet");
        portletType.setProviderApplicationType(faqAppType);
        portletType.setPortalApplication(true);
        portletType.save();
    }

    public void shutdown() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

