/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.faq.ui;


import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.bebop.table.DefaultTableCellRenderer;

import com.arsdigita.persistence.DataCollection;

import com.arsdigita.util.LockableImpl;

import java.math.BigDecimal;

class AdminQuestionTable extends Table {
    public static final String versionId = "$Id: //apps/faq/dev/src/com/arsdigita/faq/ui/AdminQuestionTable.java#2 $ by $Author: dennis $, $DateTime: 2003/08/15 13:46:34 $";

    private final static String[] HEADERS = {"#", "Question"};

    public AdminQuestionTable(TableModelBuilder builder) {
        super(builder, HEADERS);
        setDefaultCellRenderer(new QuestionCellRenderer());
    }


    static class QuestionModelBuilder extends LockableImpl
        implements TableModelBuilder {

        public TableModel makeModel(Table t, PageState s) {
            return new QuestionModel(s);
        }
    }

    private static class QuestionModel implements TableModel {
        private DataCollection m_query = null;

        public QuestionModel(PageState s) {
            m_query = ((FaqPage)s.getPage()).getFaq(s)
                .getQAPairs().getDataCollection();
        }

        public int getColumnCount() { return HEADERS.length; }

        public Object getKeyAt(int columnIndex) {
            return (BigDecimal)(m_query.get("id"));
        }

        public Object getElementAt(int columnIndex) {
            Object ret = null;

            switch (columnIndex) {
            case 0:
                ret = m_query.get("sortKey");
                break;

            case 1:
                ret = m_query.get("question");
                break;

            default:
                ret = "filler";
            }

            return ret;
        }

        public boolean nextRow() {
            return m_query.next();
        }

    }

    private static class QuestionCellRenderer extends DefaultTableCellRenderer {
        public Component getComponent(Table table, PageState state,
                                      Object value, boolean isSelected,
                                      Object key, int row, int column) {

            switch (column) {
            case 0:
                return super.getComponent(table, state, value,
                                          isSelected, key, row, column);
            case 1:
                return new ControlLink(value.toString());

            default:
                return null;
            }
        }
    }

}
