/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.faq;

import com.arsdigita.faq.Faq;
import com.arsdigita.faq.QAPair;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.populate.Utilities;
import com.arsdigita.populate.apps.AbstractPopulateApp;
import com.arsdigita.populate.apps.PopulateApp;
import com.arsdigita.util.Assert;
import com.arsdigita.web.ApplicationType;
import java.util.List;

public class PopulateFaq
extends AbstractPopulateApp
implements PopulateApp {
    private static final String ARGS_DESC = "1 PopulateFaq arg: numQuestions";

    public void populateApp(List args) {
        Session ses = SessionManager.getSession();
        TransactionContext txn = ses.getTransactionContext();
        Faq faq = (Faq)this.getApp();
        this.validateArgs(args, 1, ARGS_DESC);
        int iQuestions = (Integer)args.get(0);
        Assert.assertTrue((iQuestions >= 0 ? 1 : 0) != 0, (String)"iQuestions must be >= 0");
        for (int i = 0; i < iQuestions; ++i) {
            txn.beginTxn();
            String sQuestion = "This is question " + i;
            String sAnswer = Utilities.makeText((int)i);
            QAPair pair = faq.createQuestion(sQuestion, sAnswer);
            this.s_log.info((Object)("created FAQ question " + i));
            txn.commitTxn();
        }
    }

    public String getArgsDescription() {
        return ARGS_DESC;
    }

    public ApplicationType getAppType() {
        return ApplicationType.retrieveApplicationTypeForApplication((String)"com.arsdigita.faq.Faq");
    }

    protected String getPortletType() {
        return "com.arsdigita.faq.FaqQuestionsPortlet";
    }
}

