/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.faq;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.util.TypedText;

import java.math.BigDecimal;

/**
 * Represents the question-answer pairs making up a FAQ
 *
 */


public class QAPair extends ACSObject {

    public static final String versionId = "$Id: //apps/faq/dev/src/com/arsdigita/faq/QAPair.java#3 $ by $Author: dennis $, $DateTime: 2003/08/15 13:46:34 $";

    private static final org.apache.log4j.Logger s_log =
        org.apache.log4j.Logger.getLogger(QAPair.class);

    public static final String BASE_DATA_OBJECT_TYPE
        = "com.arsdigita.faq.QAPair";

    private Faq m_faq = null;

    public QAPair() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public QAPair(String typeName) {
        super(typeName);
    }

    public QAPair(ObjectType type) {
        super(type);
    }

    public QAPair(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public QAPair(BigDecimal key) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, key));
    }

    public QAPair(DataObject dataObj) {
        super(dataObj);
    }

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }


    public String getQuestion() {
        return (String) get("question");
    }

    public void setQuestion(String question) {
        set("question", question);
    }

    public Faq getFaq() {
        if (m_faq == null) {
            DataObject faqData = (DataObject) get("faq");
            if (faqData != null) {
                m_faq = new Faq(faqData);
            }
        }
        return m_faq;
    }

    public void setFaq(Faq faq) {
        m_faq = faq;
        setAssociation("faq", faq);
    }

    public Integer getSortKey() {
        return (Integer) get("sortKey");
    }

    public void setSortKey(Integer sortKey) {
        set("sortKey", sortKey);
    }

    public TypedText getAnswer() {
        return new TypedText((String)get("answer"),
                             (String)get("answerFormat"));
    }

    public void setAnswer(TypedText answer) {
        set("answer", answer.getText());
        set("answerFormat", answer.getType());
    }
}
