/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.faq.ui;

import com.arsdigita.faq.Faq;
import com.arsdigita.faq.QAPair;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;

import com.arsdigita.persistence.DataCollection;

import com.arsdigita.util.LockableImpl;

class QAList extends List {

    public static final String versionId = "$Id: //apps/faq/dev/src/com/arsdigita/faq/ui/QAList.java#2 $ by $Author: dennis $, $DateTime: 2003/08/15 13:46:34 $";

    public QAList() {
        super();
        setModelBuilder(new QAListModelBuilder());
        setCellRenderer(new QACellRenderer());
    }

    private class QAListModelBuilder extends LockableImpl
        implements ListModelBuilder {

        public ListModel makeModel(List l, PageState s) {
            return new QAListModel(s);
        }
    }

    private class QAListModel implements ListModel {
        private DataCollection m_query;

        public QAListModel(PageState s) {
            Faq faq = ((FaqPage)s.getPage()).getFaq(s);
            m_query = faq.getQAPairs().getDataCollection();
        }

        public Object getElement() {
            return new QAPair(m_query.getDataObject());
        }

        public String getKey() {
            return m_query.get("id").toString();
        }

        public boolean next() {
            return m_query.next();
        }
    }

    private class QACellRenderer implements ListCellRenderer {
        public Component getComponent(List list, PageState state,
                                      Object value, String key,
                                      int index, boolean isSelected) {
            return new QAView((QAPair) value);
        }
    }

}
