/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.faq.ui;

import com.arsdigita.faq.Faq;

import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.portal.AbstractPortletRenderer;
import com.arsdigita.bebop.PageState;
import com.arsdigita.xml.Element;
import com.arsdigita.web.URL;
import com.arsdigita.persistence.DataAssociationCursor;
import java.math.BigDecimal;

public class FaqQuestionsPortletRenderer extends AbstractPortletRenderer {
    public static final String versionId = "$Id: //apps/faq/dev/src/com/arsdigita/faq/ui/FaqQuestionsPortletRenderer.java#3 $ by $Author: dennis $, $DateTime: 2003/08/15 13:46:34 $";

    private FaqQuestionsPortlet m_portlet;

    public FaqQuestionsPortletRenderer(FaqQuestionsPortlet
                                       faqQuestionsPortlet) {
        m_portlet = faqQuestionsPortlet;
    }

    protected void generateBodyXML(PageState pageState,
                                   Element parentElement) {
        Faq faq = (Faq) m_portlet.getParentApplication();

        DataAssociationCursor questionAnswerPairs =
            faq.getQAPairs().cursor();

        GridPanel panel = new GridPanel(1);

        String url = URL.getDispatcherPath() + faq.getPrimaryURL();

        while (questionAnswerPairs.next()) {
            String id = ((BigDecimal) questionAnswerPairs.get("id")).toString();
            String question = (String) questionAnswerPairs.get("question");

            // TODO - figure out how to do this with a link.
            // After an hour, I couldn't find a way.

            // the thing which is a problem is setting the fragment

            Label link = new Label("<a href=" + url + "#" + id + ">" +
                                   question + "</a>", false);
            panel.add(link);
        }

        panel.generateXML(pageState, parentElement);
    }
}
