/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.faq;

import com.arsdigita.faq.ui.FaqPage;
import com.arsdigita.faq.ui.FaqAdminView;
import com.arsdigita.faq.ui.FaqUserView;

import com.arsdigita.bebop.BebopMapDispatcher;
import com.arsdigita.bebop.Page;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

/**
 * Faq dispatcher for both Bebop-backed and other URLs.
 *
 * @author Kevin Scaldeferri (kevin@arsdigita.com)
 * @version $Revision: #3 $ $Date: 2003/08/15 $
 */

public class FaqDispatcher extends BebopMapDispatcher {

    public static final String versionId = "$Id: //apps/faq/dev/src/com/arsdigita/faq/FaqDispatcher.java#3 $ by $Author: dennis $, $DateTime: 2003/08/15 13:46:34 $";

    private static final Logger s_log =
        Logger.getLogger(FaqDispatcher.class);

    public FaqDispatcher() {
        super();

        Map m = new HashMap();

        Page index = buildIndexPage();
        Page admin = buildAdminIndexPage();

        m.put("", index);
        m.put("index.jsp", index);
        m.put("one.jsp", index);

        m.put("admin/", admin);
        m.put("admin/index.jsp", admin);

        setMap(m);
    }

    private FaqPage buildIndexPage() {
        FaqPage p = new FaqPage();

        p.add(new FaqUserView());

        /*CommentsService commentsService =
         *  new CommentsService(req, FaqHelper.getFaqID(req));
         *  p.add(commentsService.buildCommentsComponent(
         *  "comments/one-object"));
         */

        p.lock();
        return p;
    }


    private FaqPage buildAdminIndexPage() {

        FaqPage p = new FaqPage("admin");

        FaqAdminView faqAdminTabs = new FaqAdminView();
        faqAdminTabs.setKey("FaqAdminTabs");
        p.add(faqAdminTabs);

        p.lock();
        return p;
    }

}
