/*
 * Decompiled with CFR 0.152.
 */
package dom;

import dom.ParserWrapper;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Writer {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String LEXICAL_HANDLER_PROPERTY_ID = "http://xml.org/sax/properties/lexical-handler";
    protected static final String DEFAULT_PARSER_NAME = "dom.wrappers.Xerces";
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_CANONICAL = false;
    protected PrintWriter fOut;
    protected boolean fCanonical;
    protected boolean fXML11;

    public Writer() {
    }

    public Writer(boolean bl) {
        this.fCanonical = bl;
    }

    public void setCanonical(boolean bl) {
        this.fCanonical = bl;
    }

    public void setOutput(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        if (string == null) {
            string = "UTF8";
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
        this.fOut = new PrintWriter(outputStreamWriter);
    }

    public void setOutput(java.io.Writer writer) {
        this.fOut = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public void write(Node node) {
        if (node == null) {
            return;
        }
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                Document document = (Document)node;
                this.fXML11 = "1.1".equals(this.getVersion(document));
                if (!this.fCanonical) {
                    if (this.fXML11) {
                        this.fOut.println("<?xml version=\"1.1\" encoding=\"UTF-8\"?>");
                    } else {
                        this.fOut.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    }
                    this.fOut.flush();
                    this.write(document.getDoctype());
                }
                this.write(document.getDocumentElement());
                break;
            }
            case 10: {
                DocumentType documentType = (DocumentType)node;
                this.fOut.print("<!DOCTYPE ");
                this.fOut.print(documentType.getName());
                String string = documentType.getPublicId();
                String string2 = documentType.getSystemId();
                if (string != null) {
                    this.fOut.print(" PUBLIC '");
                    this.fOut.print(string);
                    this.fOut.print("' '");
                    this.fOut.print(string2);
                    this.fOut.print('\'');
                } else if (string2 != null) {
                    this.fOut.print(" SYSTEM '");
                    this.fOut.print(string2);
                    this.fOut.print('\'');
                }
                String string3 = documentType.getInternalSubset();
                if (string3 != null) {
                    this.fOut.println(" [");
                    this.fOut.print(string3);
                    this.fOut.print(']');
                }
                this.fOut.println('>');
                break;
            }
            case 1: {
                Node node2;
                this.fOut.print('<');
                this.fOut.print(node.getNodeName());
                Attr[] attrArray = this.sortAttributes(node.getAttributes());
                int n = 0;
                while (n < attrArray.length) {
                    node2 = attrArray[n];
                    this.fOut.print(' ');
                    this.fOut.print(node2.getNodeName());
                    this.fOut.print("=\"");
                    this.normalizeAndPrint(node2.getNodeValue(), true);
                    this.fOut.print('\"');
                    ++n;
                }
                this.fOut.print('>');
                this.fOut.flush();
                node2 = node.getFirstChild();
                while (node2 != null) {
                    this.write(node2);
                    node2 = node2.getNextSibling();
                }
                break;
            }
            case 5: {
                if (this.fCanonical) {
                    Node node3 = node.getFirstChild();
                    while (node3 != null) {
                        this.write(node3);
                        node3 = node3.getNextSibling();
                    }
                    break;
                }
                this.fOut.print('&');
                this.fOut.print(node.getNodeName());
                this.fOut.print(';');
                this.fOut.flush();
                break;
            }
            case 4: {
                if (this.fCanonical) {
                    this.normalizeAndPrint(node.getNodeValue(), false);
                } else {
                    this.fOut.print("<![CDATA[");
                    this.fOut.print(node.getNodeValue());
                    this.fOut.print("]]>");
                }
                this.fOut.flush();
                break;
            }
            case 3: {
                this.normalizeAndPrint(node.getNodeValue(), false);
                this.fOut.flush();
                break;
            }
            case 7: {
                this.fOut.print("<?");
                this.fOut.print(node.getNodeName());
                String string = node.getNodeValue();
                if (string != null && string.length() > 0) {
                    this.fOut.print(' ');
                    this.fOut.print(string);
                }
                this.fOut.print("?>");
                this.fOut.flush();
                break;
            }
            case 8: {
                if (this.fCanonical) break;
                this.fOut.print("<!--");
                String string = node.getNodeValue();
                if (string != null && string.length() > 0) {
                    this.fOut.print(string);
                }
                this.fOut.print("-->");
                this.fOut.flush();
            }
        }
        if (s == 1) {
            this.fOut.print("</");
            this.fOut.print(node.getNodeName());
            this.fOut.print('>');
            this.fOut.flush();
        }
    }

    protected Attr[] sortAttributes(NamedNodeMap namedNodeMap) {
        int n = namedNodeMap != null ? namedNodeMap.getLength() : 0;
        Attr[] attrArray = new Attr[n];
        int n2 = 0;
        while (n2 < n) {
            attrArray[n2] = (Attr)namedNodeMap.item(n2);
            ++n2;
        }
        int n3 = 0;
        while (n3 < n - 1) {
            Object object;
            Object object2 = attrArray[n3].getNodeName();
            int n4 = n3;
            int n5 = n3 + 1;
            while (n5 < n) {
                object = attrArray[n5].getNodeName();
                if (((String)object).compareTo((String)object2) < 0) {
                    object2 = object;
                    n4 = n5;
                }
                ++n5;
            }
            if (n4 != n3) {
                object = attrArray[n3];
                attrArray[n3] = attrArray[n4];
                attrArray[n4] = object;
            }
            ++n3;
        }
        return attrArray;
    }

    protected void normalizeAndPrint(String string, boolean bl) {
        int n = string != null ? string.length() : 0;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            this.normalizeAndPrint(c, bl);
            ++n2;
        }
    }

    protected void normalizeAndPrint(char c, boolean bl) {
        switch (c) {
            case '<': {
                this.fOut.print("&lt;");
                break;
            }
            case '>': {
                this.fOut.print("&gt;");
                break;
            }
            case '&': {
                this.fOut.print("&amp;");
                break;
            }
            case '\"': {
                if (bl) {
                    this.fOut.print("&quot;");
                    break;
                }
                this.fOut.print("\"");
                break;
            }
            case '\r': {
                this.fOut.print("&#xD;");
                break;
            }
            case '\n': {
                if (this.fCanonical) {
                    this.fOut.print("&#xA;");
                    break;
                }
            }
            default: {
                if (this.fXML11 && (c >= '\u0001' && c <= '\u001f' && c != '\t' && c != '\n' || c >= '\u007f' && c <= '\u009f' || c == '\u2028') || bl && (c == '\t' || c == '\n')) {
                    this.fOut.print("&#x");
                    this.fOut.print(Integer.toHexString(c).toUpperCase());
                    this.fOut.print(";");
                    break;
                }
                this.fOut.print(c);
            }
        }
    }

    protected String getVersion(Document document) {
        if (document == null) {
            return null;
        }
        String string = null;
        Method method = null;
        try {
            method = document.getClass().getMethod("getXmlVersion", new Class[0]);
            if (method != null) {
                string = (String)method.invoke((Object)document, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] var0) {
        if (var0.length == 0) {
            Writer.printUsage();
            System.exit(1);
        }
        var1_1 = null;
        var2_2 = null;
        var3_3 = true;
        var4_4 = false;
        var5_5 = false;
        var6_6 = false;
        var7_7 = false;
        var8_8 = 0;
        while (var8_8 < var0.length) {
            block37: {
                var9_9 = var0[var8_8];
                if (!var9_9.startsWith("-")) ** GOTO lbl-1000
                var10_10 = var9_9.substring(1);
                if (var10_10.equals("p")) {
                    if (++var8_8 == var0.length) {
                        System.err.println("error: Missing argument to -p option.");
                    }
                    var11_18 = var0[var8_8];
                    try {
                        var2_2 = (ParserWrapper)Class.forName((String)var11_18).newInstance();
                    }
                    catch (Exception var12_21) {
                        var2_2 = null;
                        System.err.println("error: Unable to instantiate parser (" + (String)var11_18 + ")");
                    }
                } else if (var10_10.equalsIgnoreCase("n")) {
                    var3_3 = var10_10.equals("n");
                } else if (var10_10.equalsIgnoreCase("v")) {
                    var4_4 = var10_10.equals("v");
                } else if (var10_10.equalsIgnoreCase("s")) {
                    var5_5 = var10_10.equals("s");
                } else if (var10_10.equalsIgnoreCase("f")) {
                    var6_6 = var10_10.equals("f");
                } else if (var10_10.equalsIgnoreCase("c")) {
                    var7_7 = var10_10.equals("c");
                } else if (var10_10.equals("h")) {
                    Writer.printUsage();
                } else lbl-1000:
                // 2 sources

                {
                    if (var2_2 == null) {
                        try {
                            var2_2 = (ParserWrapper)Class.forName("dom.wrappers.Xerces").newInstance();
                        }
                        catch (Exception var10_11) {
                            System.err.println("error: Unable to instantiate parser (dom.wrappers.Xerces)");
                            break block37;
                        }
                    }
                    try {
                        var2_2.setFeature("http://xml.org/sax/features/namespaces", var3_3);
                    }
                    catch (SAXException var10_12) {
                        System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/namespaces)");
                    }
                    try {
                        var2_2.setFeature("http://xml.org/sax/features/validation", var4_4);
                    }
                    catch (SAXException var10_13) {
                        System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/validation)");
                    }
                    try {
                        var2_2.setFeature("http://apache.org/xml/features/validation/schema", var5_5);
                    }
                    catch (SAXException var10_14) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema)");
                    }
                    try {
                        var2_2.setFeature("http://apache.org/xml/features/validation/schema-full-checking", var6_6);
                    }
                    catch (SAXException var10_15) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
                    }
                    if (var1_1 == null) {
                        var1_1 = new Writer();
                        try {
                            var1_1.setOutput(System.out, "UTF8");
                        }
                        catch (UnsupportedEncodingException var10_16) {
                            System.err.println("error: Unable to set output. Exiting.");
                            System.exit(1);
                        }
                    }
                    var1_1.setCanonical(var7_7);
                    try {
                        var10_10 = var2_2.parse(var9_9);
                        var1_1.write((Node)var10_10);
                    }
                    catch (SAXParseException var10_17) {
                    }
                    catch (Exception var11_19) {
                        System.err.println("error: Parse error occurred - " + var11_19.getMessage());
                        if (var11_19 instanceof SAXException && (var12_20 = ((SAXException)var11_19).getException()) != null) {
                            var11_18 = var12_20;
                        }
                        var11_18.printStackTrace(System.err);
                    }
                }
            }
            ++var8_8;
        }
    }

    private static void printUsage() {
        System.err.println("usage: java dom.Writer (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -p name  Select parser by name.");
        System.err.println("  -n | -N  Turn on/off namespace processing.");
        System.err.println("  -v | -V  Turn on/off validation.");
        System.err.println("  -s | -S  Turn on/off Schema validation support.");
        System.err.println("           NOTE: Not supported by all parsers.");
        System.err.println("  -f  | -F Turn on/off Schema full checking.");
        System.err.println("           NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -c | -C  Turn on/off Canonical XML output.");
        System.err.println("           NOTE: This is not W3C canonical output.");
        System.err.println("  -h       This help screen.");
        System.err.println();
        System.err.println("defaults:");
        System.err.println("  Parser:     dom.wrappers.Xerces");
        System.err.print("  Namespaces: ");
        System.err.println("on");
        System.err.print("  Validation: ");
        System.err.println("off");
        System.err.print("  Schema:     ");
        System.err.println("off");
        System.err.print("  Schema full checking:     ");
        System.err.println("off");
        System.err.print("  Canonical:  ");
        System.err.println("off");
    }
}

