/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Enumeration;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.zip.ZipOutputStream;

public class Jar
extends Zip {
    private static final String INDEX_NAME = "META-INF/INDEX.LIST";
    private Manifest configuredManifest;
    private Manifest savedConfiguredManifest;
    private Manifest filesetManifest;
    private FilesetManifestConfig filesetManifestConfig;
    private boolean manifestOnFinalize = true;
    private boolean mergeManifestsMain = true;
    private Manifest manifest;
    private File manifestFile;
    private boolean index = false;

    public Jar() {
        this.archiveType = "jar";
        this.emptyBehavior = "create";
        this.setEncoding("UTF8");
    }

    public void setWhenempty(Zip.WhenEmpty we) {
        this.log("JARs are never empty, they contain at least a manifest file", 1);
    }

    public void setJarfile(File jarFile) {
        this.setDestFile(jarFile);
    }

    public void setIndex(boolean flag) {
        this.index = flag;
    }

    public void addConfiguredManifest(Manifest newManifest) throws ManifestException {
        if (this.configuredManifest == null) {
            this.configuredManifest = newManifest;
        } else {
            this.configuredManifest.merge(newManifest);
        }
        this.savedConfiguredManifest = this.configuredManifest;
    }

    public void setManifest(File manifestFile) {
        if (!manifestFile.exists()) {
            throw new BuildException("Manifest file: " + manifestFile + " does not exist.", this.getLocation());
        }
        this.manifestFile = manifestFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Manifest getManifest(File manifestFile) {
        Manifest newManifest = null;
        FileReader r = null;
        try {
            try {
                r = new FileReader(manifestFile);
                newManifest = this.getManifest(r);
            }
            catch (IOException e) {
                throw new BuildException("Unable to read manifest file: " + manifestFile + " (" + e.getMessage() + ")", e);
            }
            Object var6_4 = null;
            if (r == null) return newManifest;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (r == null) throw throwable;
            try {
                ((Reader)r).close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        ((Reader)r).close();
        return newManifest;
    }

    private Manifest getManifest(Reader r) {
        Manifest newManifest = null;
        try {
            newManifest = new Manifest(r);
        }
        catch (ManifestException e) {
            this.log("Manifest is invalid: " + e.getMessage(), 0);
            throw new BuildException("Invalid Manifest: " + this.manifestFile, e, this.getLocation());
        }
        catch (IOException e) {
            throw new BuildException("Unable to read manifest file (" + e.getMessage() + ")", e);
        }
        return newManifest;
    }

    public void addMetainf(ZipFileSet fs) {
        fs.setPrefix("META-INF/");
        super.addFileset(fs);
    }

    protected void initZipOutputStream(ZipOutputStream zOut) throws IOException, BuildException {
        if (this.filesetManifestConfig == null || this.filesetManifestConfig.getValue().equals("skip")) {
            this.manifestOnFinalize = false;
            Manifest jarManifest = this.createManifest();
            this.writeManifest(zOut, jarManifest);
        }
    }

    private Manifest createManifest() throws IOException, BuildException {
        try {
            Manifest finalManifest = Manifest.getDefaultManifest();
            if (this.manifest == null) {
                if (this.manifestFile != null) {
                    this.manifest = this.getManifest(this.manifestFile);
                    finalManifest.merge(this.filesetManifest);
                    finalManifest.merge(this.configuredManifest);
                    finalManifest.merge(this.manifest, !this.mergeManifestsMain);
                } else if (this.configuredManifest != null) {
                    finalManifest.merge(this.filesetManifest);
                    finalManifest.merge(this.configuredManifest, !this.mergeManifestsMain);
                } else if (this.filesetManifest != null) {
                    finalManifest.merge(this.filesetManifest, !this.mergeManifestsMain);
                }
            } else {
                finalManifest.merge(this.filesetManifest);
                finalManifest.merge(this.configuredManifest);
                finalManifest.merge(this.manifest, !this.mergeManifestsMain);
            }
            return finalManifest;
        }
        catch (ManifestException e) {
            this.log("Manifest is invalid: " + e.getMessage(), 0);
            throw new BuildException("Invalid Manifest", e, this.getLocation());
        }
    }

    private void writeManifest(ZipOutputStream zOut, Manifest manifest) throws IOException {
        Enumeration e = manifest.getWarnings();
        while (e.hasMoreElements()) {
            this.log("Manifest warning: " + (String)e.nextElement(), 1);
        }
        this.zipDir(null, zOut, "META-INF/");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(baos);
        manifest.write(writer);
        writer.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        super.zipFile(bais, zOut, "META-INF/MANIFEST.MF", System.currentTimeMillis(), null);
        super.initZipOutputStream(zOut);
    }

    protected void finalizeZipOutputStream(ZipOutputStream zOut) throws IOException, BuildException {
        if (this.manifestOnFinalize) {
            Manifest jarManifest = this.createManifest();
            this.writeManifest(zOut, jarManifest);
        }
        if (this.index) {
            this.createIndexList(zOut);
        }
    }

    private void createIndexList(ZipOutputStream zOut) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)baos, "UTF8"));
        writer.println("JarIndex-Version: 1.0");
        writer.println();
        writer.println(this.zipFile.getName());
        Enumeration enumeration = this.addedDirs.keys();
        while (enumeration.hasMoreElements()) {
            String dir = (String)enumeration.nextElement();
            int pos = (dir = dir.replace('\\', '/')).lastIndexOf(47);
            if (pos != -1) {
                dir = dir.substring(0, pos);
            }
            if (dir.startsWith("META-INF")) continue;
            writer.println(dir);
        }
        writer.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        super.zipFile(bais, zOut, INDEX_NAME, System.currentTimeMillis(), null);
    }

    protected void zipFile(File file, ZipOutputStream zOut, String vPath) throws IOException {
        if ("META-INF/MANIFEST.MF".equalsIgnoreCase(vPath)) {
            this.filesetManifest(file, null);
        } else {
            super.zipFile(file, zOut, vPath);
        }
    }

    protected void zipFile(InputStream is, ZipOutputStream zOut, String vPath, long lastModified, File file) throws IOException {
        if ("META-INF/MANIFEST.MF".equalsIgnoreCase(vPath)) {
            this.filesetManifest(file, is);
        } else {
            super.zipFile(is, zOut, vPath, lastModified, null);
        }
    }

    private void filesetManifest(File file, InputStream is) {
        if (this.manifestFile != null && this.manifestFile.equals(file)) {
            this.log("Found manifest " + file, 3);
            this.manifest = is != null ? this.getManifest(new InputStreamReader(is)) : this.getManifest(file);
        } else if (this.filesetManifestConfig != null && !this.filesetManifestConfig.getValue().equals("skip")) {
            this.log("Found manifest to merge in file " + file, 3);
            try {
                Manifest newManifest = null;
                newManifest = is != null ? this.getManifest(new InputStreamReader(is)) : this.getManifest(file);
                if (this.filesetManifest == null) {
                    this.filesetManifest = newManifest;
                }
                this.filesetManifest.merge(newManifest);
            }
            catch (ManifestException e) {
                this.log("Manifest in file " + file + " is invalid: " + e.getMessage(), 0);
                throw new BuildException("Invalid Manifest", e, this.getLocation());
            }
        } else {
            int logLevel = this.filesetManifestConfig == null ? 1 : 3;
            this.log("File " + file + " includes a META-INF/MANIFEST.MF which will be ignored. " + "To include this file, set filesetManifest to a value other " + "than 'skip'.", logLevel);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isUpToDate(FileScanner[] scanners, File zipFile) throws BuildException {
        block14: {
            block15: {
                block13: {
                    if (this.configuredManifest == null && this.manifestFile != null) {
                        if (this.manifestFile.lastModified() <= zipFile.lastModified()) return super.isUpToDate(scanners, zipFile);
                        return false;
                    }
                    theZipFile = null;
                    try {
                        try {
                            theZipFile = new ZipFile(zipFile);
                            entry = theZipFile.getEntry("META-INF/MANIFEST.MF");
                            if (entry == null) {
                                this.log("Updating jar since the current jar has no manifest", 3);
                                var5_6 = false;
                                var9_9 = null;
                                if (theZipFile == null) return var5_6;
                                break block13;
                            }
                            currentManifest = new Manifest(new InputStreamReader(theZipFile.getInputStream(entry)));
                            if (currentManifest.equals(newManifest = this.createManifest())) break block14;
                            this.log("Updating jar since jar manifest has changed", 3);
                            var7_20 = false;
                            break block15;
                        }
                        catch (Exception e) {
                            this.log("Updating jar since cannot read current jar manifest: " + e.getClass().getName() + " - " + e.getMessage(), 3);
                            var5_8 = false;
                            var9_12 = null;
                            if (theZipFile == null) return var5_8;
                            try {
                                theZipFile.close();
                                return var5_8;
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                            return var5_8;
                        }
                    }
                    catch (Throwable var8_21) {
                        var9_13 = null;
                        if (theZipFile == null) throw var8_21;
                        ** try [egrp 2[TRYBLOCK] [2 : 183->190)] { 
lbl39:
                        // 1 sources

                        theZipFile.close();
                        throw var8_21;
lbl41:
                        // 1 sources

                        catch (IOException e) {
                            // empty catch block
                        }
                        throw var8_21;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [2 : 183->190)] { 
lbl46:
                // 1 sources

                theZipFile.close();
                return var5_6;
lbl48:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var5_6;
            }
            var9_10 = null;
            if (theZipFile == null) return var7_20;
            ** try [egrp 2[TRYBLOCK] [2 : 183->190)] { 
lbl55:
            // 1 sources

            theZipFile.close();
            return var7_20;
lbl57:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return var7_20;
        }
        var9_11 = null;
        if (theZipFile == null) return super.isUpToDate(scanners, zipFile);
        try {}
        catch (IOException e) {}
        theZipFile.close();
        return super.isUpToDate(scanners, zipFile);
        return super.isUpToDate(scanners, zipFile);
    }

    protected boolean createEmptyZip(File zipFile) {
        return true;
    }

    protected void cleanUp() {
        super.cleanUp();
        this.manifest = null;
        this.configuredManifest = this.savedConfiguredManifest;
        this.filesetManifest = null;
    }

    public void reset() {
        super.reset();
        this.configuredManifest = null;
        this.filesetManifestConfig = null;
        this.mergeManifestsMain = false;
        this.manifestFile = null;
        this.index = false;
    }

    public static class FilesetManifestConfig
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"skip", "merge", "mergewithoutmain"};
        }
    }
}

