/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.xmlutil;

import java.util.List;
import java.util.LinkedList;
import java.util.Iterator;

public class ResourceRegistry {


    public static ResourceRegistry instance() {
        return s_instance;
    }

    public void addResource(TestResource resource) {
        m_resources.add(resource);
    }

    public void cleanResources() {
        for (Iterator iterator = m_resources.iterator(); iterator.hasNext();) {
            TestResource resource = (TestResource) iterator.next();
            resource.cleanUp();
        }

        m_resources.clear();
    }
    private ResourceRegistry() {

    }

    private List m_resources = new LinkedList();
    private static ResourceRegistry s_instance = new ResourceRegistry();

}
