/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.workflow.simple;


import com.arsdigita.persistence.OID;
import com.arsdigita.tools.junit.framework.BaseTestCase;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.Group;

import java.util.Iterator;

/**
 * This is the Junit testcase for Task class. Assumed Tinman environment.
 *
 *
 * @author Uday Mathur
 *
 */
public class PersistenceTest extends BaseTestCase {
    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/workflow/simple/PersistenceTest.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public PersistenceTest(String name) {
        super(name);
    }

    public void testPersistence() {
        String label = "Persistence test";
        String description =  "Persistence test description";

        //Create a new task
        UserTask userTask = new UserTask(label, description);
        OID taskOID;

        //assign 5 groups to this task
        int groupCreated = 5;
        Group[] groups = new Group[groupCreated];

        for (int x = 0; x < groupCreated; x++) {
            groups[x] = new Group();
            groups[x].setName("Workflow Test " + x);
            groups[x].save();
            userTask.assignGroup(groups[x]);
        }
        //store persistently
        userTask.save();

        //let's make sure that assignGroup() actually worked by
        //that we have 5 assigned groups

        assertEquals(5,userTask.getAssignedGroupCount());

        taskOID = userTask.getOID();

        // now let's reload the object and make sure those 5 tasks
        // were stored persistently
        userTask = null;
        try {
            userTask = new UserTask(taskOID);
        } catch (DataObjectNotFoundException d) {
            fail(d.getMessage());
        }
        assertEquals(5,userTask.getAssignedGroupCount());


        //now we will create another userTask and copy the task
        //assignees from the original task (this is so you don't have
        //to sift through the ugle clone() method.
        UserTask different = new UserTask();
        Group g;
        //use this counter to make sure 5 tasks were actually copied.
        int counter = 0;
        for (Iterator i = userTask.getAssignedGroups(); i.hasNext(); counter++) {
            g = (Group) i.next();
            different.assignGroup(g);
        }
        //make sure the domain object before saving has 5 tasks
        assertEquals(5,counter);
        assertEquals(5,different.getAssignedGroupCount());
        different.save();
        taskOID = different.getOID();

        //now dump it and reload it to see if the tasks were saved to
        //persistent storage (When sifting through the logs I did not
        //find the correct insert statement)
        different = null;
        try {
            different = new UserTask(taskOID);
        } catch (DataObjectNotFoundException d) {
            fail(d.getMessage());
        }
        assertEquals(5,different.getAssignedGroupCount());
    }
}
