/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.web;

import com.arsdigita.tools.junit.framework.BaseTestCase;
import com.arsdigita.util.*;


public class WebTestCase extends BaseTestCase {

    DispatcherServlet m_dispatcher;
    TestServletContainer m_container;
    protected DummyServletConfig m_config;

    public WebTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();

        m_config = new DummyServletConfig("DispatcherServlet");
        m_config.setInitParameter(DispatcherServlet.FALLBACK_SERVLET_PARAMETER, "DummyServlet");
        DummyServletContext ctx = (DummyServletContext) m_config.getServletContext();
        ctx.addDispacher("DummyServlet", new DummyServlet());
        m_dispatcher = new DispatcherServlet();
        m_dispatcher.init(m_config);

        HttpServletDummyRequest req = new HttpServletDummyRequest("localhost:8080", "", "/ccm", "/", null);
        HttpServletDummyResponse res = new HttpServletDummyResponse();
        m_container = new TestServletContainer(req, res);
        m_container.addServletMapping("/ccm", m_dispatcher);

    }

}
