/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.web;

/**
 * Class ApplicationTest
 *
 * @author jross@redhat.com
 */
public class ApplicationTest extends WebTestCase {
    public ApplicationTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();

        ApplicationDispatchTest.setupApplication();
   }

    public void testRetrieveAll() throws Exception {
        // This tests for a problem described in bz 113122

        final long before = Application.retrieveAllApplications().size();

        final Application app1 = Application.createApplication
            (TestApplication.BASE_DATA_OBJECT_TYPE, "yeehah", "Yee Hah", null);

        final Application app2 = Application.createApplication
            (TestApplication.BASE_DATA_OBJECT_TYPE, "waahoo", "Waa Hoo", null);

        // Application.retrieveAllApplications() should *not* return
        // this app, since I'm making it look like a portlet.
        app2.getApplicationType().setFullPageView(false);

        final long after = Application.retrieveAllApplications().size();

        if (after - before > 1) {
            fail("Found a non-application in a set returned by " +
                 "Application.retrieveAllApplications()");
        }
    }
}
