/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.versioning;

import com.arsdigita.tools.junit.framework.BaseTestCase;

/**
 * This is not a test case. It's just a way for me to produce a graphical
 * representation of the versioning dependency graph.
 *
 * @author  Vadim Nasardinov (vadimn@redhat.com)
 * @since   2003-07-31
 * @version $Revision: #5 $ $Date: 2004/04/07 $
 **/
public class PrettyPrintTest extends BaseTestCase implements Const {

    public PrettyPrintTest(String name) {
        super(name);
    }

    public void testVersioningEventProcessorGraph() {
        Filter filter = new Filter("versioning.events");
        DevSupport.pdlToDot(filter);
        DevSupport.versioningGraphToDot(filter);
    }

    public void testObjectTypeMetadataGraph() {
        Filter filter = new Filter("versioning.metadata");
        DevSupport.pdlToDot(filter);
        DevSupport.versioningGraphToDot(filter);
    }
}
