/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.versioning;

import com.arsdigita.persistence.OID;
import com.arsdigita.tools.junit.framework.BaseTestCase;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Date;

import org.apache.log4j.Logger;

public class AdapterTest extends BaseTestCase {
    private static final Logger s_log = Logger.getLogger(AdapterTest.class);

    public AdapterTest(String name) {
        super(name);
    }

    public void testDate() {
        Date expected = new Date();
        Date actual = (Date) Adapter.deserialize(Adapter.serialize(expected),
                                                 Types.DATE);
        assertEquals("serialized/deserialized date", expected, actual);
    }

    public void testTimestamp() {
        Timestamp expected = new Timestamp(System.currentTimeMillis());
        expected.setNanos(1973);
        Timestamp actual = (Timestamp)
            Adapter.deserialize(Adapter.serialize(expected),
                                Types.TIMESTAMP);
        assertEquals("serialized/deserialized timestamp", expected, actual);
    }

    public void testBigDecimalOID() {
        final String type = "versioning.serialization.DecimalKey";

        OID expected = new OID(type, new BigDecimal(12345));
        OID actual = (OID) Adapter.deserialize(Adapter.serialize(expected),
                                               Types.OID);
        assertEquals("serialized/deserialized oid", expected, actual);
    }

    public void testBigIntegerOID() {
        final String type = "versioning.serialization.IntegerKey";

        OID expected = new OID(type, new BigInteger("12345"));
        OID actual = (OID) Adapter.deserialize(Adapter.serialize(expected),
                                               Types.OID);
        assertEquals("serialized/deserialized oid", expected, actual);
    }


    public void testMultiKeyOID() {
        final String type = "versioning.serialization.CompoundKey";

        OID expected = new OID(type);
        expected.set("id2", new BigDecimal(54321));
        expected.set("sid", "foobar");
        expected.set("id1", new BigInteger("12345"));

        s_log.debug("expected=" + Adapter.serialize(expected));

        OID actual = (OID) Adapter.deserialize(Adapter.serialize(expected),
                                               Types.OID);
        assertEquals("serialized/deserialized oid", expected, actual);
        
    }
}
