/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.test.ddl;

import junit.framework.*;
import java.io.*;

/**
 * DDLDiffTest
 *
 * @author <a href="mailto:rhs@mit.edu">rhs@mit.edu</a>
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 **/

public class DDLDiffTest extends TestCase {

    public final static String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/test/ddl/DDLDiffTest.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public DDLDiffTest(String name) {
        super(name);
    }

    public void test() throws IOException, InterruptedException {
/*        Runtime run = Runtime.getRuntime();
        Process diff =
            run.exec("diff -udrbB " +
                     "test/src/com/arsdigita/test/ddl/canonical " +
                     new File(new File(System.getProperty("build.sql.dir")),
                              "ddl"));
        diff.waitFor();
        String error = read(new InputStreamReader(diff.getErrorStream()));
        String output = read(new InputStreamReader(diff.getInputStream()));
        assertEquals("", error);
        assertEquals("", output);
        */
    }

    private static final String read(Reader rdr) throws IOException {
        StringBuffer result = new StringBuffer();

        char[] buf = new char[1024];

        int read;

        do {
            read = rdr.read(buf);
            if (read > -1) {
                result.append(buf, 0, read);
            }
        } while (read > -1);

        return result.toString();
    }

}
