/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.lucene;

import com.arsdigita.tools.junit.framework.*;
import org.apache.log4j.Logger;

/**
 * LuceneTest
 *
 * @author <a href="mailto:rhs@mit.edu">rhs@mit.edu</a>
 * @version $Revision: #4 $ $Date: 2004/04/07 $
 **/

public class LuceneTest extends LuceneTestCase {

    public final static String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/search/lucene/LuceneTest.java#4 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger(LuceneTest.class);
    private static final String NAME =
        "This is a note.";
    private static final String TEXT =
        "This is the test text included in the note.";

    public LuceneTest(String name) {
        super(name);
    }

    public void testStandardAdapter() {
        Adapter ad = Note.adapter();

        Note note = new Note();
        note.setName(NAME);
        note.setText(TEXT);

        assertEquals(note.getID(), ad.getID(note));
        assertEquals(note.getObjectType(), ad.getObjectType(note));
        assertEquals(note.getName(), ad.getTitle(note));
        assertEquals(note.getText(), ad.getContent(note));
    }

    public void testObserver() throws Exception {
        Registry reg = Registry.getInstance();
        reg.addAdapter(Note.BASE_DATA_OBJECT_TYPE, Note.adapter());

        Note note = new Note();
        note.setName(NAME);
        note.setText(TEXT);
        note.save();

        Document doc = Document.retrieve(note.getID());
        assertEquals(NAME, doc.getTitle());
        assertEquals(TEXT, doc.getContent());
    }

    public void testIndexer() throws java.io.IOException {
        Registry reg = Registry.getInstance();
        reg.addAdapter(Note.BASE_DATA_OBJECT_TYPE, Note.adapter());

        Note note = new Note();
        note.setName(NAME);
        note.setText(TEXT + " " + note.getID());
        note.save();

        Indexer idx = new Indexer(Index.getLocation());
        idx.sync();

        // This is kindof a hack since it's possible there are other things in
        // the index that will contain the same search term since the search
        // index isn't cleared between test runnings. I should really add ID
        // based search in order to do this right.
        LuceneSearch search = new LuceneSearch(note.getID().toString());
        if (search.next()) {
            assertEquals(note.getID(), search.getID());
            assertEquals(note.getName(), search.getTitle());
            assertEquals(note.getText(), search.getContent());
        } else {
            fail("Search or indexer failed.");
        }
    }


}
