/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.lucene;

import com.arsdigita.tools.junit.extensions.BaseTestSetup;
import com.arsdigita.tools.junit.extensions.CoreTestSetup;
import com.arsdigita.tools.junit.framework.PackageTestSuite;
import com.arsdigita.search.Search;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.framework.TestResult;
import org.apache.log4j.Logger;

/**
 * LuceneSuite
 *
 * @author <a href="mailto:rhs@mit.edu">rhs@mit.edu</a>
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 **/

public class LuceneSuite extends PackageTestSuite {

    public final static String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/search/lucene/LuceneSuite.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger(LuceneSuite.class);

    public LuceneSuite() {}

    public LuceneSuite(Class theClass) {
        super(theClass);
    }

    public LuceneSuite(String name) {
        super(name);
    }

    public static Test suite() {
        LuceneSuite suite = new LuceneSuite();
        populateSuite(suite);
        BaseTestSetup wrapper = new SearchTestSetup(suite);
        wrapper.addSQLSetupScript("/com/arsdigita/search/lucene/setup.sql");
        wrapper.addSQLTeardownScript("/com/arsdigita/search/lucene/teardown.sql");
        return wrapper;
    }

    private static class SearchTestSetup extends CoreTestSetup {
        private boolean m_isLuceneEnabled = false;
        public SearchTestSetup(TestSuite suite) {
            super(suite);

            if (Search.getConfig().isLuceneEnabled()) {
                if (Search.getConfig().getLazyUpdates()) {
                    s_log.warn("Lucene tests do not currently work correctly with lazy updates enabled. Tests disabled");

                } else {
                    m_isLuceneEnabled = true;
                }
            }
        }

        public void basicRun(TestResult testResult) {
            if (isLuceneEnabled()) {
                super.basicRun(testResult);
            }
        }

        private boolean isLuceneEnabled() {
            return m_isLuceneEnabled;
        }

        protected void setupSQL () throws Exception {
            if (isLuceneEnabled()) {
                super.setupSQL();
            }
        }


        protected void teardownSQL() throws Exception {
            if (isLuceneEnabled()) {
                super.teardownSQL();
            }
        }

    }

    public static void main(String[] args) throws Exception {
        junit.textui.TestRunner.run(suite());
    }

}
