/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.intermedia;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.kernel.ACSObjectInstantiator;

import java.math.BigDecimal;

/**
 * SearchTestChapterH class.  Used to test generating XML documents
 * for related objects.
 *
 * @author Jeff Teeters
 **/
public class SearchTestChapterH extends ACSObject
    implements SearchIndexHelpCustomize {
    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/search/intermedia/SearchTestChapterH.java#3 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.search.intermedia.SearchTestChapterH";

    public SearchTestChapterH() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public SearchTestChapterH(String typeName) {
        super(typeName);
    }

    public SearchTestChapterH(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public SearchTestChapterH(int key)  throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, key));
    }

    public SearchTestChapterH(DataObject chapterData) {
        super(chapterData);
    }


    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public String getDisplayName() {
        return "SearchTestChapterH-DisplayName";
    }

    /* Register instantiator with DomainObjectFactory, must be called by
       initializer */
    public static void setupDomainObjectFactory() {
        DomainObjectInstantiator instantiator;

        instantiator = new ACSObjectInstantiator() {
                public DomainObject doNewInstance(DataObject dataObject) {
                    return new SearchTestChapterH(dataObject);
                }
            };
        DomainObjectFactory.registerInstantiator(
                                                 SearchTestChapterH.BASE_DATA_OBJECT_TYPE,
                                                 instantiator);
    }


    public Integer getChapterNum() {
        return (Integer) get("chapterNum");
    }

    public void setChapterNum(Integer num) {
        set("chapterNum", num);
    }

    public BigDecimal getBookId() {
        return (BigDecimal) get("bookId");
    }

    public void setBookId(BigDecimal num) {
        set("bookId", num);
    }

    public String getContent() {
        return  (String)get("content");
    }

    public void setContent(String content) {
        set("content", content);
    }

    private final static String [] FIELDS = {
        "chapterNum" + "XML",
        "content" + "RAW"
    };

    public String[] searchIndexHelpFields() {
        return FIELDS;
    }
}
