/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.intermedia;

import com.arsdigita.search.Search;
import com.arsdigita.tools.junit.extensions.BaseTestSetup;
import com.arsdigita.tools.junit.extensions.CoreTestSetup;
import com.arsdigita.tools.junit.framework.PackageTestSuite;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.framework.TestResult;

/**
 * SearchSuite
 *
 * @author Daniel Berrange
 * @version 1.0
 **/
public class SearchSuite extends PackageTestSuite {
    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/search/intermedia/SearchSuite.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public SearchSuite() {
        super();
    }

    public SearchSuite(Class theClass) {
        super(theClass);
    }

    public SearchSuite(String name) {
        super(name);
    }

    public static Test suite() {
        SearchSuite suite = new SearchSuite();
        populateSuite(suite);
        BaseTestSetup wrapper = new SearchTestSetup(suite);
        wrapper.setSetupSQLScript( "/com/arsdigita/search/setup.sql");
        wrapper.setTeardownSQLScript( "/com/arsdigita/search/teardown.sql");
        return wrapper;
    }


    // Only want to run tests if Intermedia search is enabled.
    private static class SearchTestSetup extends CoreTestSetup {
        public SearchTestSetup(TestSuite suite) {
            super(suite);
        }

        public void basicRun(TestResult testResult) {
            if (Search.getConfig().isIntermediaEnabled()) {
                super.basicRun(testResult);
            }
        }

        protected void setupSQL () throws Exception {
            if (Search.getConfig().isIntermediaEnabled()) {
                super.setupSQL();
            }
        }


        protected void teardownSQL() throws Exception {
            if (Search.getConfig().isIntermediaEnabled()) {
                super.teardownSQL();
            }
        }

    }

    public static void main(String[] args) throws Exception {
        junit.textui.TestRunner.run( suite() );
    }
}
