/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search;

import com.arsdigita.persistence.OID;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.util.Assert;
import java.util.Date;
import java.util.Locale;

public class TestDocument {
    
    private OID m_oid;
    private Locale m_locale;
    private String m_title;
    private String m_summary;
    private Date m_creationDate;
    private Party m_creationParty;
    private Date m_modifiedDate;
    private Party m_modifiedParty;
    private String m_text;

    public TestDocument(DomainObject dobj,
                        MetadataProvider metadata) {
        m_oid = dobj.getOID();
        m_locale = metadata.getLocale(dobj);
        m_title = metadata.getTitle(dobj);
        m_summary = metadata.getSummary(dobj);
        m_creationDate = metadata.getCreationDate(dobj);
        m_creationParty = metadata.getCreationParty(dobj);
        m_modifiedDate = metadata.getLastModifiedDate(dobj);
        m_modifiedParty = metadata.getLastModifiedParty(dobj);
        
        ContentProvider[] content = metadata.getContent(dobj,
                                                        ContentType.TEXT);
        StringBuffer buf = new StringBuffer("");
        for (int i = 0 ; i < content.length ; i++) {
            Assert.truth(content[i].getType() == ContentType.TEXT,
                         "content is text");
            buf.append(new String(content[i].getBytes()));
        }
        m_text = buf.toString();
    }

    public int hashCode() {
        return m_oid.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof TestDocument) {
            return m_oid.equals(((TestDocument)o).m_oid);
        }
        return false;
    }

    public OID getOID() {
        return m_oid;
    }
    public Locale getLocale() {
        return m_locale;
    }
    public String getTitle() {
        return m_title;
    }
    public String getSummary() {
        return m_summary;
    }
    public Date getCreationDate() {
        return m_creationDate;
    }
    public Party getCreationParty() {
        return m_creationParty;
    }
    public Date getLastModifiedDate() {
        return m_modifiedDate;
    }
    public Party getLastModifiedParty() {
        return m_modifiedParty;
    }
    public String getText() {
        return m_text;
    }
}
