/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.test;


// Interface of the class that we are testing
import com.arsdigita.formbuilder.PersistentComponentFactory;

// The class we are testing
import com.arsdigita.formbuilder.SimpleQuestionnaire;

// Component factories
import com.arsdigita.formbuilder.PersistentTextArea;
import com.arsdigita.formbuilder.PersistentTextField;

// Some components that we add
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.Label;

// For the id of the questionnaire
import java.math.BigDecimal;

// Reference class
import com.arsdigita.bebop.Form;

// Interfaces used by the component base test case
import com.arsdigita.bebop.Component;

// logging
import org.apache.log4j.Logger;


/**
 * Test the SimpleQuestionnaire class.
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/test/src/com/arsdigita/formbuilder/test/SimpleQuestionnaireTest.java#9 $
 *
 */
public class SimpleQuestionnaireTest extends PersistentComponentTestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/formbuilder/test/SimpleQuestionnaireTest.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private final static Logger s_log =
        Logger.getLogger(SimpleQuestionnaireTest.class.getName());

    String m_label0 = "Question 0";
    String m_label1 = "Question 1";
    String m_label2 = "Question 2";

    String m_submitLabel = "go";

    String m_htmlName = "questionnaire_html_name";

    String m_adminName = "Questionnaire Admin Name";

    String m_description = "Questionnaire Description";

    // The class we are testing
    private SimpleQuestionnaire m_questionnaire;

    private BigDecimal m_questionnaireID;

    /**
     * JUnit needs this constructor
     */
    public SimpleQuestionnaireTest(String name) {
        super(name);
    }

    // *** Methods inherited from PersistentComponentTestCase

    /**
     * This method returns an instance of the appropriate factory.
     */
    protected PersistentComponentFactory createPrimaryPersistentFactory() {

        SimpleQuestionnaire questionnaire =
            new SimpleQuestionnaire(m_htmlName, m_adminName);

        questionnaire.setDescription(m_description);

        PersistentTextArea widget1 = PersistentTextArea.create(m_label1);
        widget1.save();
        PersistentTextField widget0 = PersistentTextField.create(m_label0);
        widget0.save();
        PersistentTextArea widget2 = PersistentTextArea.create(m_label2);
        widget2.save();

        // Add a label / text field pair
        questionnaire.addQuestion(m_label1, widget1);

        // Add a label / text area pair at position 1
        questionnaire.addQuestion(m_label0, widget0, 1);

        // Set the submit label
        questionnaire.setSubmitLabel(m_submitLabel);

        // Add another label and text area
        questionnaire.addQuestion(m_label2, widget2);

        // Remove question 1 (at position 2)
        questionnaire.removeQuestion(2);

        // Reorder the questions
        questionnaire.moveQuestion(2, 1);

        return questionnaire;
    }

    /**
     * This method creates a new reference component and populates it with
     * test data
     */
    protected Component createPrimaryReferenceComponent() {

        Form form = new Form(m_htmlName);

        // Remember that we removed question number 1 and reordered question 2 and 0
        form.add(new Label(m_label2));
        form.add(new TextArea(m_label2));

        form.add(new Label(m_label0));
        form.add(new TextField(m_label0));

        form.add(new Submit("submit", m_submitLabel));

        return form;
    }

    /**
     * Some components have attributes that the corresponding Bebop component
     * does not have. Those should be checked (after the component has been
     * retrieved from the database) in this method.
     */
    protected void checkPersistenceAttributes(PersistentComponentFactory factory) {

        SimpleQuestionnaire questionnaire = (SimpleQuestionnaire)factory;

        assertEquals(questionnaire.getAdminName(), m_adminName);
        assertEquals(questionnaire.getDescription(), m_description);
    }
}
