/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.test;


// The class we are testing
import com.arsdigita.formbuilder.PersistentDate;

// Interface of the class that we are testing
import com.arsdigita.formbuilder.PersistentComponentFactory;

// Interfaces used by the base test case
import com.arsdigita.bebop.Component;

// For reference
import com.arsdigita.bebop.form.Date;
import com.arsdigita.bebop.parameters.DateParameter;

// logging
import org.apache.log4j.Logger;

// Secondary use-cases
import java.util.HashMap;
import java.util.Map;

/**
 * Test the PersistentDate class with the test pattern defined in
 * PersistentComponentTestCase.
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/test/src/com/arsdigita/formbuilder/test/PersistentDateTest.java#9 $
 */
public class PersistentDateTest extends PersistentComponentTestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/formbuilder/test/PersistentDateTest.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    // Logging
    private final static Logger s_log =
        Logger.getLogger(PersistentDateTest.class.getName());

    // Properties of the text area
    private static String m_htmlName = "Test Date Name";
    private static java.util.Date m_defaultValue = new java.util.Date();

    /**
     * JUnit needs this constructor
     */
    public PersistentDateTest(String name) {
        super(name);
    }

    // *** Methods inherited from PersistentComponentTestCase

    /**
     * This method returns an instance of the appropriate factory.
     */
    protected PersistentComponentFactory createPrimaryPersistentFactory() {

        PersistentDate factory =
            PersistentDate.create(m_htmlName);

        // We cannot set a String default value
        try {

            factory.setDefaultValue("test string default value");

            fail("PersistentDate.setDefaultValue() should not accept a String");

        } catch (IllegalArgumentException e) {
            // This is what we wanted
        }

        factory.setDefaultValue(m_defaultValue);

        factory.setYearRange(1974, 2001);

        return factory;
    }

    /**
     * This method creates a new reference component and populates it with
     * test data
     */
    protected Component createPrimaryReferenceComponent() {
        Date date = new Date(m_htmlName);

        date.setDefaultValue(m_defaultValue);

        date.setYearRange(1974, 2001);

        return date;
    }

    /**
     * Returns a map with use-case names as keys and PersistentComponentFactory:s as values.
     * Each factory is populated with different
     * data that reflects a secondary use-case. The components created by these factories
     * will compared with the reference component in the same position in the list returned
     * by createSecondaryReferenceComponents().
     */
    protected Map createSecondaryPersistentFactories() {

        // Intentionally empty for optional implementation by sub classes
        HashMap useCaseMap = new HashMap();

        // Setting the DateParameter class
        // I should ideally be using a sub class of DateParameter here
        PersistentDate date = (PersistentDate)createPrimaryPersistentFactory();
        date.setDateParameter("com.arsdigita.bebop.parameters.DateParameter");
        useCaseMap.put("custom_date_parameter", date);

        return new HashMap();
    }

    /**
     * Returns a map with use-case names as keys and reference components as values.
     * Each reference component is populated with different
     * data that reflects a secondary use-case.
     */
    protected Map createSecondaryReferenceComponents() {

        // Intentionally empty for optional implementation by sub classes
        HashMap useCaseMap = new HashMap();

        // Setting the DateParameter class
        useCaseMap.put("custom_date_parameter", createPrimaryReferenceComponent());

        return new HashMap();
    }

    // We do not override the checkPersistenceAttributes() method since we keep
    // no persistence specific attributes for the Date
}
