/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.test;

// The class that we are overriding
import com.arsdigita.tools.junit.framework.PackageTestSuite;

// The class that we register the initializer with
import com.arsdigita.tools.junit.extensions.BaseTestSetup;
import com.arsdigita.tools.junit.extensions.PermissionDecorator;
import com.arsdigita.tools.junit.extensions.CoreTestSetup;

// To contain all tests of the package
import junit.framework.Test;


/**
 * This class is responsible for adding all Form Builder unit tests
 * to a test suite so that they can all be run. The class also makes
 * sure that the Form Builder initializer (and all initializers before
 * it in enterprise.init) is run.
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/test/src/com/arsdigita/formbuilder/test/FormbuilderSuite.java#10 $
 *
 */
public class FormbuilderSuite extends PackageTestSuite {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/formbuilder/test/FormbuilderSuite.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public FormbuilderSuite(String name) {
        super(name);
    }

    public void addTest(Test test) {
        PermissionDecorator perm = new PermissionDecorator(test);
        super.addTest(perm);
    }


    public static Test suite() {

        FormbuilderSuite suite = new FormbuilderSuite("Form Builder Test Suite");
        populateSuite(suite);
        BaseTestSetup wrapper = new CoreTestSetup(suite);

        return wrapper;
    }
}
