/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.parameters;

import com.arsdigita.bebop.parameters.*;
import com.arsdigita.bebop.*;
import com.arsdigita.tools.junit.framework.BaseTestCase;
import com.arsdigita.util.HttpServletDummyRequest;

import java.lang.IllegalArgumentException;

public class NumberParameterTest extends BaseTestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/bebop/parameters/NumberParameterTest.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
       Constructs a test with the specified name.

       @param name Name of the test
    */
    protected ParameterModel _stringParameter;
    protected ParameterModel _numberParameter;
    protected HttpServletDummyRequest _httpRequest;

    public NumberParameterTest(String id) {
        super(id);
    }

    /**
       Sets up the test fixture.
    */

    protected void setUp() {
        _stringParameter =  new StringParameter("StringParameter");
        _numberParameter =  new NumberParameter("NumberParameter");
        _httpRequest = new HttpServletDummyRequest();

    }

    /**
       Tears down the text fixture.
       Called after every test case method.
    */

    protected void tearDown() {

        _stringParameter=null;
        _numberParameter=null;
        _httpRequest=null;

    }
    public void testNumberParameterNoValues() {

        String[] specifiedValues = {};
        _httpRequest.setParameterValues("NumberParameter",specifiedValues );
        assertEquals(_numberParameter.transformValue(_httpRequest),null);

    }

    public void testNumberParameterBadValue() {

        String[] specifiedValues = {"Not a Number"};
        _httpRequest.setParameterValues("NumberParameter",specifiedValues );
        try {
            Integer temp = (Integer)_numberParameter.transformValue(_httpRequest);
            // if you get here an exception was not raised
            fail();
        } catch (IllegalArgumentException iae) {
            // ok.
        }
    }

    public void testNumberParameterSomeBadValue() {
        String[] specifiedValues = {"5","Not a Number"};
        _httpRequest.setParameterValues("NumberParameter",specifiedValues );
        assertEquals(_numberParameter.transformValue(_httpRequest),new Integer("5"));
    }

    public void testNumberParameterGoodIntegerValue() {
        String[] specifiedValues = {"5"};
        _httpRequest.setParameterValues("NumberParameter",specifiedValues );
        assertEquals(_numberParameter.transformValue(_httpRequest),new Integer("5"));
    }

    public void testNumberParameterGoodFloatValue() {
        String[] specifiedValues = {"5.01"};
        _httpRequest.setParameterValues("NumberParameter",specifiedValues );
        assertEquals(_numberParameter.transformValue(_httpRequest),new Float("5.01"));
    }
    /*
      Move this to NumberArrayTest.java
      public void testNumberParameterSomeBadValues() {
      String[] specifiedValues = {"5", "Not a Number"};
      _httpRequest.setParameterValues("NumberParameter",specifiedValues );
      try {
      Object[] temp = _numberParameter.transformValues(_httpRequest);
      //if you get here an exception was not raised
      assert(false);
      } catch (IllegalArgumentException iae) {
      assert(true);
      }
      }

      public void testNumberParameterGoodFloatValues() {
      String[] specifiedValues = {"5.01","4.05"};
      _httpRequest.setParameterValues("NumberParameter",specifiedValues );
      assertEquals(_numberParameter.transformValues(_httpRequest)[1],new Float("4.05"));
      }
    */
}
