/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.parameters;

import com.arsdigita.bebop.parameters.*;
import com.arsdigita.bebop.event.*;
import com.arsdigita.bebop.*;

public class EnumerationValidationListenerTest
    extends ValidationListenerTest {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/bebop/parameters/EnumerationValidationListenerTest.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
       Constructs a test with the specified name.

       @param name Name of the test
    */


    public EnumerationValidationListenerTest(String id) {
        super(id);
    }

    public void testEnumerationEmptyParameter() {

        String[] allowedValues={"this","is","a","test"};
        String[] specifiedValues={};

        _httpRequest.setParameterValues("StringParameter", specifiedValues);
        _validationListener=new EnumerationValidationListener(allowedValues);
        _stringParameter.addParameterListener(_validationListener);

        createFormData();
        ParameterData data = _formData.getParameter("StringParameter");
        try {
            data.validate();
            assertTrue(data.isValid());
        } catch (FormProcessException fpe) {
            fail("FormProcessException fpe " + fpe.getMessage());
        }
    }

    public void testEnumerationEmptyAllowed() {

        String[] allowedValues={};
        String[] specifiedValues={"not a member"};

        _httpRequest.setParameterValues("StringParameter", specifiedValues);
        _validationListener=new EnumerationValidationListener(allowedValues);
        _stringParameter.addParameterListener(_validationListener);

        createFormData();
        ParameterData data = _formData.getParameter("StringParameter");
        try {
            data.validate();
            assertTrue(!data.isValid());
        } catch (FormProcessException fpe) {
            fail("FormProcessException fpe" + fpe.getMessage());
        }
    }

    public void testEnumerationBadParameter() {

        String[] allowedValues={"this","is","a","test"};
        String[] specifiedValues={"not a member"};

        _httpRequest.setParameterValues("StringParameter", specifiedValues);
        _validationListener=new EnumerationValidationListener(allowedValues);
        _stringParameter.addParameterListener(_validationListener);

        createFormData();
        ParameterData data = _formData.getParameter("StringParameter");
        try {
            data.validate();
            assertTrue(!data.isValid());
        } catch (FormProcessException fpe) {
            fail("FormProcessException fpe");
        }
    }
    /*
      array types used here
      public void testEnumerationBadParameterMix() {

      String[] allowedValues={"this","is","a","test"};
      String[] specifiedValues={"this","not a member"};

      _httpRequest.setParameterValues("StringParameter", specifiedValues);
      _validationListener=new EnumerationValidationListener(allowedValues);
      _stringParameter.addParameterListener(_validationListener);

      try {(!_validationListener.validate(_httpRequest,
      _stringParameter,
      _formData));

      }
    */

    public void testEnumerationBadParameterCase() {

        String[] allowedValues={"this","is","a","test"};
        String[] specifiedValues={"THIS"};

        _httpRequest.setParameterValues("StringParameter", specifiedValues);
        _validationListener=new EnumerationValidationListener(allowedValues,true);
        _stringParameter.addParameterListener(_validationListener);

        createFormData();
        ParameterData data = _formData.getParameter("StringParameter");
        try {
            data.validate();
            assertTrue(!data.isValid());
        } catch (FormProcessException fpe) {
            fail("FormProcessException fpe");
        }
    }
    public void testEnumerationGoodParameterCase() {

        String[] allowedValues={"this","is","a","test"};
        String[] specifiedValues={"THIS"};

        _httpRequest.setParameterValues("StringParameter", specifiedValues);
        _validationListener=new EnumerationValidationListener(allowedValues);
        _stringParameter.addParameterListener(_validationListener);

        createFormData();
        ParameterData data = _formData.getParameter("StringParameter");
        try {
            data.validate();
            assertTrue(data.isValid());
        } catch (FormProcessException fpe) {
            fail("FormProcessException fpe");
        }
    }

    public void testEnumerationGoodParametersCase() {

        String[] allowedValues={"this","is","a","test"};
        String[] specifiedValues={"THIS","test","test"};

        _httpRequest.setParameterValues("StringParameter", specifiedValues);
        _validationListener=new EnumerationValidationListener(allowedValues);
        _stringParameter.addParameterListener(_validationListener);

        createFormData();
        ParameterData data = _formData.getParameter("StringParameter");
        try {
            data.validate();
            assertTrue(data.isValid());
        } catch (FormProcessException fpe) {
            fail("FormProcessException fpe");
        }
    }
}
