/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.parameters;

import com.arsdigita.bebop.parameters.*;
import com.arsdigita.bebop.*;
import com.arsdigita.tools.junit.framework.BaseTestCase;
import com.arsdigita.util.HttpServletDummyRequest;

import java.lang.IllegalArgumentException;

public class EmailParameterTest extends BaseTestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/bebop/parameters/EmailParameterTest.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
       Constructs a test with the specified name.

       @param name Name of the test
    */

    protected ParameterModel _emailParameter;
    protected HttpServletDummyRequest _httpRequest;

    public EmailParameterTest(String id) {
        super(id);
    }

    /**
       Sets up the test fixture.
    */

    protected void setUp() {
        _emailParameter =  new EmailParameter("EmailParameter");
        _httpRequest = new HttpServletDummyRequest();
    }

    /**
       Tears down the text fixture.
       Called after every test case method.
    */

    protected void tearDown() {
        _emailParameter=null;
        _httpRequest=null;
    }

    public void testEmailParameterNoValues() {

        String[] specifiedValues = {};
        _httpRequest.setParameterValues("EmailParameter",specifiedValues );
        assertEquals(_emailParameter.transformValue(_httpRequest),null);

    }

    public void testEmailParameterBadValue() {
        String[] specifiedValues = {"not a valid address"};
        _httpRequest.setParameterValues("EmailParameter",specifiedValues );
        try {
            Object temp = _emailParameter.transformValue(_httpRequest);
            fail("an IllegalArgumentException should have been thrown");
        } catch (IllegalArgumentException iae) {
            // ok.
        }
    }

    public void testEmailParameterBadValueURL() {
        String[] specifiedValues = {"http://www.yahoo.com"};
        _httpRequest.setParameterValues("EmailParameter",specifiedValues );
        try {
            Object temp = _emailParameter.transformValue(_httpRequest);
            fail("an IllegalArgumentException should have been thrown");
        } catch (IllegalArgumentException iae) {
            // ok.
        }
    }

    public void testEmailParameterGoodValue() {
        String[] specifiedValues = {"umathur@arsdigita.com"};
        _httpRequest.setParameterValues("EmailParameter",specifiedValues );
        try {
            Object temp = _emailParameter.transformValue(_httpRequest);
            assertEquals("umathur@arsdigita.com", temp.toString());
        } catch (IllegalArgumentException iae) {
            // ok.
        }
    }

    // FIXME: This fails currently
    public void testEmailParameterGoodValueNotFullyQualified() {
        String[] specifiedValues = {"umathur@sf"};
        _httpRequest.setParameterValues("EmailParameter",specifiedValues );
        try {
            Object temp = _emailParameter.transformValue(_httpRequest);
            // assertEquals("umathur@sf", temp.toString());
        } catch (IllegalArgumentException iae) {
            // fail(iae.toString());
        }
    }

    // FIXME: This fails currently
    public void testEmailParameterGoodValueNoDomain() {
        String[] specifiedValues = {"umathur"};
        _httpRequest.setParameterValues("EmailParameter",specifiedValues );
        try {
            Object temp = _emailParameter.transformValue(_httpRequest);
            // assertEquals("umathur", temp.toString());
        } catch (IllegalArgumentException iae) {
            // fail(iae.toString());
        }
    }

}
