/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.form;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ComponentTestHarness;
import com.arsdigita.util.HttpServletDummyRequest;
import com.arsdigita.util.HttpServletDummyResponse;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ActionEvent;

/**
 * Regression tests for the text field widget
 *
 * @version $Revision: #11 $ $Date: 2004/04/07 $
 */

public class SelectTest extends Fixture {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/bebop/form/SelectTest.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public SelectTest (String id) {
        super(id);
    }

    /**
     *  Test a Select
     */
    public void testSelect() {
        Select sel = new SingleSelect("select");
        m_form.add(sel);
        sel.addOption(new Option("foovalue", "foo"));
        sel.addOption(new Option("barvalue", "bar"));
        sel.addOption(new Option("bazvalue", "baz"));
        m_page.lock();
        testComponent(sel, "select");
    }

    /**
     *  Test a Select with options added in a print listener
     */
    public void testSelectPrintListener() {
        Select sel = new SingleSelect("select");
        m_form.add(sel);
        sel.addOption(new Option("foovalue", "foo"));
        try {
            sel.addPrintListener(new PrintListener() {
                    public void prepare(PrintEvent evt) {
                        Select target = (Select)evt.getTarget();
                        target.addOption(new Option("barvalue", "bar"));
                        target.addOption(new Option("bazvalue", "baz"));
                    }
                });
        } catch (java.util.TooManyListenersException e) { }
        m_page.lock();
        testComponent(sel, "select");
    }

    /**
     *  Test a Select with options added in a form init listener
     */
    public void testSelectFormInitListener() {
        final Select sel = new SingleSelect("select");
        m_form.add(sel);
        sel.addOption(new Option("foovalue", "foo"));
        m_page.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent evt) {
                    PageState ps = evt.getPageState();
                    sel.addOption(new Option("barvalue", "bar"), ps);
                    sel.addOption(new Option("bazvalue", "baz"), ps);
                }
            });
        // NOTE: this is an oddball method because the default testComponent
        // method builds a new page and doesn't call action listeners
        // or form listeners on it.

        final ComponentTestHarness harness = new ComponentTestHarness(m_page);
        try {
            String xml = m_page.buildDocument(harness.getServletRequest(), harness.getServletResponse()).toString();
            assertTrue(xml, xml.indexOf("foo") >= 0);
            assertTrue(xml, xml.indexOf("bar") >= 0);
            assertTrue(xml, xml.indexOf("baz") >= 0);
        } catch (Exception e) {
            fail(e.getMessage());
        }
    }

}
