/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;

/**
 *  An implementation of ComponentXMLComparator for regression testing single
 *  Components. The XML name is taken from the fully qualified class name
 *  of the component.
 *
 * @version $Revision: #8 $ $Date: 2004/04/07 $
 */
public class SingleComponentXMLComparator extends ComponentXMLComparator
{

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/bebop/SingleComponentXMLComparator.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    /**
     *  Constucts a comparator for a lone Component.
     *
     *  @param c The Component to perform XML comparison on.
     *
     */
    public SingleComponentXMLComparator(Component c, String testName) throws Exception {
        super(c, testName, c.getClass().getName() + ".xml");
    }


}
