/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;

/**
 *  An implementation of ComponentXMLComparator for regression testing
 *  compound Components. The XML name is provided by the user, and should
 *  be a good description of the compound document.
 *
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 */
public class CompoundComponentXMLComparator extends ComponentXMLComparator
{

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/bebop/CompoundComponentXMLComparator.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    /**
     *  Constucts a comparator for a Component.
     *
     *  @param c The component to perform XML comparison on.
     *  @param xmlFileName Some descriptive name for the xml file.
     *
     */
    public CompoundComponentXMLComparator(Component c, String testName)
    {
        super(c, testName, c.getClass().getName() + ".xml");
    }

    /**
     *  Constucts a comparator for a Component.
     *
     *  @param c The component to perform XML comparison on.
     *  @param xmlFileName Some descriptive name for the xml file.
     *
     */
    public CompoundComponentXMLComparator(Page p, String testName) throws Exception
    {
        super(p, testName, p.getClass().getName() + ".xml");
    }


}
