/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.form.*;
import com.arsdigita.bebop.event.*;
import com.arsdigita.bebop.parameters.*;
import com.arsdigita.bebop.parameters.*;
import junit.framework.TestCase;
import com.arsdigita.bebop.event.*;
import com.arsdigita.util.HttpServletDummyResponse;
import com.arsdigita.util.HttpServletDummyRequest;
import com.arsdigita.util.RequestEnvironment;

/**
 * @author Uday Mathur 
 * @version $Id: //core-platform/dev/test/src/com/arsdigita/bebop/BebopPipelineTest.java#9 $
 * */
public class BebopPipelineTest extends TestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/bebop/BebopPipelineTest.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
       Constructs a test with the specified name.
    */
    protected Page _page;
    protected Form _form;
    protected TextField _text1;
    protected TextField _text2;

    private RequestEnvironment m_env;


    public BebopPipelineTest(String id) {
        super(id);
    }

    /**
       Sets up the test fixture.
    */
    protected void setUp() {

        _page = new Page();
        _form = new Form("TestForm");
        _text1 = new TextField("text1");
        _text2 = new TextField(new IntegerParameter("text2"));
        _form.add(_text1);
        _form.add(_text2);
        addListeners();
        _page.add(_form);
        m_env = new RequestEnvironment();

    }

    private void addListeners() {
        _form.addInitListener( new FormInitListener() {
                public void init(FormSectionEvent event) throws FormProcessException {

                    FormData data = event.getFormData();
                    data.put("first_name", "initValue");
                    data.put("last_name", "initValue");
                }
            }
                               );

        _form.addProcessListener( new FormProcessListener() {
                public void process(FormSectionEvent event) throws FormProcessException {

                    FormData data = event.getFormData();
                    data.put("first_name", "processedValue");
                    data.put("last_name", "processedValue");
                }
            }
                                  );
        _form.addProcessListener( new FormProcessListener() {
                public void process(FormSectionEvent event) throws FormProcessException {

                    FormData data = event.getFormData();
                    data.put("last_name", "processedValue2");
                }
            }
                                  );
    }


    /**
       Tears down the text fixture.
       Called after every test case method.
    */
    protected void tearDown() {
        _page = null;
        _form = null;
        _text1 = null;
        _text2 = null;
    }
    public void testPageLocking() {
        _page.lock();

        TextField _text3 = new TextField("text3");
        try {
            _form.add(_text3);
            fail("Added widget to locked form");
        } catch (IllegalStateException e) {}
        try {
            _page.add(_text3);
            fail("Added widget to locked page");
        } catch (IllegalStateException e) {}
        try {
            _form.addProcessListener( new FormProcessListener() {
                    public void process(FormSectionEvent event)
                        throws FormProcessException {
                    }
                }
                                      );
            fail("Added listener to locked form");
        } catch (IllegalStateException e) {}
        try {
            _form.addInitListener( new FormInitListener() {
                    public void init(FormSectionEvent event)
                        throws FormProcessException {
                    }
                }
                                   );
            fail("Added listener to locked form");
        } catch (IllegalStateException e) {}
    }

    public void TestListeners() {
        _form.addValidationListener( new FormValidationListener() {
                public void validate(FormSectionEvent event) throws FormProcessException {

                    FormData data = event.getFormData();
                    data.addError("first_name","testError");
                }
            }
                                     );
        _page.lock();
    }
}
