/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.web;

import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import org.apache.log4j.Logger;

/**
 * <p>A signal to <code>BaseServlet</code> requesting that the current
 * transaction be committed or aborted.  As with all exceptions,
 * throwing a <code>TransactionSignal</code> stops the execution of
 * currently running code.</p>
 *
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //core-platform/dev/src/com/arsdigita/web/TransactionSignal.java#11 $
 */
class TransactionSignal extends Error {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/web/TransactionSignal.java#11 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static Logger s_log = Logger.getLogger(TransactionSignal.class);

    private final boolean m_isCommitRequested;

    TransactionSignal(boolean isCommitRequested) {
        if (s_log.isDebugEnabled()) {
            s_log.debug("Constructing a transaction signal with " +
                        "isCommitRequested set " + isCommitRequested);
        }

        m_isCommitRequested = isCommitRequested;

        if (m_isCommitRequested) {
            final Session session = SessionManager.getSession();

            if (session != null && session.getTransactionContext().inTxn()) {
                session.flushAll();
            }
        }
    }

    public final boolean isCommitRequested() {
        return m_isCommitRequested;
    }
}
