/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.web;

import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

/**
 * <p>A <code>RedirectSignal</code> that sends the client to the login
 * UI.  <code>LoginSignal</code> encodes the origin URL so that
 * <code>ReturnSignal</code> can return the client to its starting
 * point.</p>
 *
 * @see com.arsdigita.web.ReturnSignal
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //core-platform/dev/src/com/arsdigita/web/LoginSignal.java#7 $
 */
public class LoginSignal extends RedirectSignal {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/web/LoginSignal.java#7 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(LoginSignal.class);

    /**
     * Constructs a signal to redirect the client to log in.  This
     * constructor tells the base servlet to abandon the current
     * transaction.
     */
    public LoginSignal(final HttpServletRequest sreq) {
        this(sreq, false);
    }

    /**
     * Constructs a signal to redirect the client to log in.
     *
     * @param isCommitRequest whether or not to commit the current
     * transaction before redirecting
     */
    public LoginSignal(final HttpServletRequest sreq, 
                       final boolean isCommitRequested) {
        super(URL.login(sreq), isCommitRequested);
    }
}
