/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.web;

import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.util.Assert;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

/**
 * @deprecated This class is still considered experimental
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //core-platform/dev/src/com/arsdigita/web/CachePolicy.java#4 $
 */
public abstract class CachePolicy {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/web/CachePolicy.java#4 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(CachePolicy.class);

    public static final CachePolicy USER = new UserPolicy();
    public static final CachePolicy WORLD = new WorldPolicy();
    public static final CachePolicy DISABLE = new DisablePolicy();

    public final void implement(final HttpServletRequest sreq,
                                final HttpServletResponse sresp) {
        if (Assert.isEnabled()) {
            Assert.truth(!sresp.isCommitted());
        }

        doImplement(sreq, sresp);

        if (Assert.isEnabled()) {
            Assert.truth(!sresp.isCommitted());
        }
    }

    public abstract void doImplement(final HttpServletRequest sreq,
                                     final HttpServletResponse sresp);

    private static class UserPolicy extends CachePolicy {
        public final void doImplement(final HttpServletRequest sreq,
                                      final HttpServletResponse sresp) {
            DispatcherHelper.maybeCacheForUser(sresp);
        }
    }

    private static class WorldPolicy extends CachePolicy {
        public final void doImplement(final HttpServletRequest sreq,
                                      final HttpServletResponse sresp) {
            DispatcherHelper.maybeCacheForWorld(sresp);
        }
    }

    private static class DisablePolicy extends CachePolicy {
        public final void doImplement(final HttpServletRequest sreq,
                                      final HttpServletResponse sresp) {
            DispatcherHelper.maybeCacheDisable(sresp);
        }
    }

}
