/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.versioning;

import com.arsdigita.runtime.RuntimeConfigLoader;
import org.apache.log4j.Logger;

/**
 * An entry point for the services of the versioning package.
 *
 * @author Justin Ross
 * @see com.arsdigita.versioning.VersioningConfig
 */
final class Versioning {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/versioning/Versioning.java#4 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(Versioning.class);

    private static final VersioningConfig s_config = new VersioningConfig();

    static {
        final RuntimeConfigLoader loader = new RuntimeConfigLoader();

        loader.load("ccm-core/versioning.properties", false);

        s_config.load(loader);
    }

    /**
     * Returns the versioning config record.
     *
     * @post return != null
     */
    public static final VersioningConfig getConfig() {
        return s_config;
    }
}
