/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.versioning;

import com.arsdigita.domain.DomainQuery;
import com.arsdigita.persistence.DataCollection;

// merged versioning

/**
 * A collection of {@link Transaction}s. Instances of this class are returned by
 * various {@link Versions} methods.
 *
 */
public class TransactionCollection extends DomainQuery {

    private DataCollection m_transactions;

    /**
     * Construct a new TransactionCollection.
     *
     * @param transactions A data collection containing the transactions.
     */
    TransactionCollection(DataCollection transactions) {
        super(transactions);
        m_transactions = transactions;
    }

    /**
     * Return the current transaction
     */
    public Transaction getTransaction() {
        return new Transaction(m_transactions.getDataObject());
    }

}
