/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.versioning;

import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.Property;

/**
 * Operation
 *
 * @author Rafael H. Schloming &lt;rhs@mit.edu&gt;
 * @version $Revision: #15 $ $Date: 2004/04/07 $
 **/

public class Operation {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/versioning/Operation.java#15 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public static interface Switch {
        void onCreate();

        void onDelete();

        void onSet();

        void onAdd();

        void onRemove();
    }

    public static abstract class Type {

        private String m_name;
        private int m_sortKey;

        private Type(String name, int sortKey) {
            m_name = name;
            m_sortKey = sortKey;
        }

        public abstract void dispatch(Switch sw);

        int sortKey() {
            return m_sortKey;
        }

        public String toString() {
            return m_name;
        }

    }

    public static final Type CREATE = new Type("create", 0) {
        public void dispatch(Switch sw) {
            sw.onCreate();
        }
    };
    public static final Type SET = new Type("set", 1) {
        public void dispatch(Switch sw) {
            sw.onSet();
        }
    };
    public static final Type ADD = new Type("add", 2) {
        public void dispatch(Switch sw) {
            sw.onAdd();
        }
    };
    public static final Type REMOVE = new Type("remove", 3) {
        public void dispatch(Switch sw) {
            sw.onRemove();
        }
    };
    public static final Type DELETE = new Type("delete", 4) {
        public void dispatch(Switch sw) {
            sw.onDelete();
        }
    };

    private Type m_type;
    private OID m_object;
    private Property m_property;
    private Object m_argument;

    Operation(Type type, OID object) {
        m_type = type;
        m_object = object;
        m_property = null;
        m_argument = null;
    }

    Operation(Type type, OID object, String property, Object argument) {
        m_type = type;
        m_object = object;
        m_property = object.getObjectType().getProperty(property);
        m_argument = argument;
    }

    public Type getType() {
        return m_type;
    }

    public OID getObject() {
        return m_object;
    }

    public Property getProperty() {
        return m_property;
    }

    public Object getArgument() {
        return m_argument;
    }

}
