/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.ui.sitemap;


import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ToggleLink;
import com.arsdigita.bebop.Tree;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.tree.TreeModelBuilder;
import com.arsdigita.kernel.SiteNode;
import com.arsdigita.ui.util.GlobalizationUtil;
import com.arsdigita.util.LockableImpl;
import org.apache.log4j.Logger;

public class SiteListing extends BoxPanel
    implements ChangeListener, ActionListener {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/ui/sitemap/SiteListing.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log =
        Logger.getLogger(SiteListing.class);

    private List m_list;

    private Tree m_tree;

    private ToggleLink m_addLink;

    public SiteListing () {
        super(BoxPanel.VERTICAL, false);
        SiteNode sn;
        try {
            sn = SiteNode.getSiteNode("/");
            m_tree = new Tree(new SitemapTreeModelBuilder());
            add(new Label(GlobalizationUtil.globalize("ui.sitemap.h4sitemap_treeh4"),  false));
            add(m_tree);
            m_tree.addChangeListener(this);
        } catch(com.arsdigita.domain.DataObjectNotFoundException e) {
            s_log.warn ("Problem Creating Site Map Tree");
            e.printStackTrace();
        }

        m_addLink = new ToggleLink(new Label(GlobalizationUtil.globalize("ui.sitemap.configure_sitemap_admin_page")));
        add(m_addLink);
        Label l = new Label(GlobalizationUtil.globalize("ui.sitemap.configure_sitemap_admin_page"));
        l.setFontWeight(Label.BOLD);
        m_addLink.setSelectedComponent(l);
        m_addLink.addActionListener(this);

    }

    public List getList() {
        return m_list;
    }

    public Tree getTree() {
        return m_tree;
    }

    public ToggleLink getCFGLink() {
        return m_addLink;
    }

    // List selection has changed
    public void stateChanged(ChangeEvent e) {
        PageState s = e.getPageState();
        if ( m_tree.isSelected(s) ) {
            m_addLink.setSelected(s, false);
        }
    }

    // Toggle link has been clicked
    public void actionPerformed(ActionEvent e) {
        PageState s = e.getPageState();
        if ( m_addLink.isSelected(s) ) {
            m_tree.clearSelection(s);
        }
    }

    private class SitemapTreeModelBuilder extends LockableImpl
        implements TreeModelBuilder {

        public com.arsdigita.bebop.tree.TreeModel makeModel(Tree t, PageState s) {
            return new SiteNodeTreeModel(SiteNode.getRootSiteNode());
        }
    }
}
