/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.ui.permissions;

import com.arsdigita.bebop.PageState;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.persistence.OID;
import java.math.BigDecimal;

/**
 * This class is mainly instantiated from a PageState. It is very
 * context specific for permissions. It tries to read the object_id
 * and load the corresponding ACSObject, as well as the party_id and
 * the corresponding entity.
 *
 * @author Stefan Deusch
 * @version $id$
 */
class UserObjectStruct implements PermissionsConstants {
    private static ParameterModel s_object_id_param
        = new BigDecimalParameter(OBJECT_ID);

    private Party m_party;
    private ACSObject m_object;

    UserObjectStruct(PageState s) {
        this(getParty(s), getObject(s));
    }

    UserObjectStruct(BigDecimal partyID, BigDecimal objectID){
        this(loadParty(partyID), loadObject(objectID));
    }

    UserObjectStruct(Party p, ACSObject o) {
        m_party  = p;
        m_object = o;
    }

    Party getParty() {
        return m_party;
    }

    ACSObject getObject() {
        return m_object;
    }

    // Utility factory methods

    static ACSObject loadObject(BigDecimal id) {
        ACSObject obj = null;
        obj = (ACSObject) DomainObjectFactory
                .newInstance(new OID(ACSObject.BASE_DATA_OBJECT_TYPE, id));
        return obj;
    }

    static ACSObject loadObject(OID oid) {
        ACSObject obj = null;
        obj = (ACSObject) DomainObjectFactory.newInstance(oid);
        return obj;
    }

    // use in package

    static Party loadParty(BigDecimal id) {
        Party party = null;
        try {
            party = User.retrieve(id);
        } catch(DataObjectNotFoundException e1) {
            // ok, then try to load a group
              party = new Group(id);
        }
        return party;
    }

    public static Party getParty(PageState s) {
        return Kernel.getContext().getParty();
    }

    public static ACSObject getObject(PageState s) {
        BigDecimal id = (BigDecimal)s.getValue(s_object_id_param);
        return loadObject(id);
    }

}
