/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.ui.permissions;

import com.arsdigita.bebop.BebopMapDispatcher;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.ui.login.UserAuthenticationListener;

/**
 * Dispatcher for the permissions UI package.
 * Manages permissions admin pages.
 * The dispatcher is mounted at /permissions/
 * Below that, an index page is mounted at "" or "index",
 * a particualar object's permission page is mounted at "one".
 *
 * @author sdeusch@arsditgita.com
 * @version $Id: //core-platform/dev/src/com/arsdigita/ui/permissions/PermissionsDispatcher.java#10 $
 */

public class PermissionsDispatcher extends BebopMapDispatcher
    implements PermissionsConstants {

    public final static String APPLICATION_NAME = "permissions";

    /**
     * Initializes dispatcher by registering above listed URLs
     * with bebop pages.
     */

    public PermissionsDispatcher() {
        Page index = buildIndexPage();
        Page single = buildItemPage();
        
        addPage("", index);
        addPage("index", index);
        addPage("one", single);
        addPage("grant", single);
        addPage("denied", buildDeniedPage());
    }

    protected void preprocessRequest(HttpServletRequest req,
                                     HttpServletResponse resp,
                                     RequestContext ctx,
                                     String url) {
        // No caching thankyou!
        DispatcherHelper.cacheDisable(resp);
    }

    private Page buildIndexPage() {
        Label title = new Label(PERMISSIONS_INDEX);
        title.setClassAttr("heading");

        Page p = PageFactory.buildPage(APPLICATION_NAME,
                                       title);
        p.addRequestListener(new UserAuthenticationListener());
        p.add(new IndexPanel());
        p.lock();
        return p;
    }

    private Page buildDeniedPage() {
        Page p = PageFactory.buildPage(APPLICATION_NAME,
                                       new Label(PAGE_DENIED_TITLE));
        Label label = new Label();
        label.setClassAttr("AccessDenied");
        p.add(label);
        p.lock();
        return p;
    }

    private Page buildItemPage() {
        PermissionsPane pane = new PermissionsPane();
        
        Page p = PageFactory.buildPage(APPLICATION_NAME,
                                       pane.getTitle());
        p.addRequestListener(new UserAuthenticationListener());
        p.add(pane);
        p.lock();
        return p;
    }
}
