/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.ui.admin;

// Apache regexp
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.StringSubstitution;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Util;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.log4j.Logger;

/**
 * Utilities class for the Admin UI package.  Provides functionality like
 * preparing search query strings and, well, not much else.
 *
 * @author Kevin Scaldeferri 
 */

final class Utilities {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/ui/admin/Utilities.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(Utilities.class);
    /**
     * Helper method to prepare the search string.  Currently removes
     * extraneous spaces and quotes the string.  should live somewhere
     * more general
     */

    static final String prepare(String input) {
        Perl5Compiler compiler = new Perl5Compiler();
        Perl5Matcher matcher = new Perl5Matcher();

        Pattern pattern;

        StringSubstitution emptySub = new StringSubstitution("");

        // remove spaces at beginning
        try {
            pattern = compiler.compile("^ +");
        } catch (MalformedPatternException e) {
            pattern = null;
            s_log.warn("Perl5Compiler choked on '^ +'", e);
        }

        String preTrimmed = Util.substitute(
                                            matcher, pattern, emptySub, input);

        // remove spaces at the end
        try {
            pattern = compiler.compile(" +$");
        } catch (MalformedPatternException e) {
            pattern = null;
            s_log.warn("Perl5Compiler choked on ' +$'");
        }

        String allTrimmed = Util.substitute(
                                            matcher, pattern, emptySub, preTrimmed);

        // remove multiple spaces
        try {
            pattern = compiler.compile("  +");
        } catch (MalformedPatternException e) {
            pattern = null;
        }

        String noExtras = Util.substitute(
                                          matcher, pattern, new StringSubstitution(" "), allTrimmed);

        return quote(noExtras);
    }

    /**
     * Helper method to quote a String.  Converts every internal
     * occurence of "'" with "''" so the resulting string can be
     * passed to the SQL processor.  Needs to move into some generic
     * utility package.
     *
     * @param text is the string to be quoted
     */

    static final String quote(String input) {

        String q = "'";

        Perl5Compiler compiler = new Perl5Compiler();
        Perl5Matcher  matcher  = new Perl5Matcher();
        StringSubstitution sub = new StringSubstitution("''");

        Pattern pattern;

        try {
            pattern = compiler.compile(q);
        } catch (MalformedPatternException e) {
            pattern = null;
        }

        return Util.substitute
            (matcher, pattern, sub, input, Util.SUBSTITUTE_ALL);
    }

}
