/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.ui.admin;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Resettable;
import com.arsdigita.bebop.SegmentedPanel;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.list.ListCellRenderer;
import java.math.BigDecimal;

/**
 * User search panel.
 *
 * @author David Dao
 */

class UserSearchPane extends SegmentedPanel
    implements AdminConstants,
               Resettable,
               ChangeListener
{
    private SearchAndList m_searchAndList;
    private AdminSplitPanel m_splitPanel;
    private UserBrowsePane m_userBrowsePane;

    /**
     * Constructor
     */

    public UserSearchPane (AdminSplitPanel panel,
                           UserBrowsePane  userBrowsePane)
    {
        m_splitPanel     = panel;
        m_userBrowsePane = userBrowsePane;
        m_searchAndList  = makeUserSearch();

        SimpleContainer body = new SimpleContainer();
        body.add(m_searchAndList);

        addSegment(SEARCH_PANEL_HEADER, body);
    }

    public void reset (PageState ps) {
        m_searchAndList.reset(ps);
    }

    private SearchAndList makeUserSearch() {
        SearchAndList s = new SearchAndList("user_search");
        s.addChangeListener(this);
        s.setListModel(new UserSearchAndListModel());
        s.setResultCellRenderer(new ListCellRenderer() {
                public Component getComponent(List list,
                                              PageState state,
                                              Object value,
                                              String key, int index,
                                              boolean isSelected) {
                    return new ControlLink(value.toString());
                }
            });

        return s;
    }

    /**
     * Display user information panel when click on search result.
     */

    public void stateChanged (ChangeEvent e) {
        PageState ps = e.getPageState();
        m_splitPanel.setTab(USER_TAB_BROWSE_INDEX, e.getPageState());

        String id = (String) m_searchAndList.getSelectedKey(ps);
        if (id != null) {
            ps.setValue(USER_ID_PARAM, new BigDecimal(id));
            m_userBrowsePane.displayUserInfoPanel(ps);
        } else {
            reset(ps);
        }
    }

}
