/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.ui.admin;

import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;


import java.math.BigDecimal;

/**
 * A utility class to support group search functionality.
 *
 * @version $Id: //core-platform/dev/src/com/arsdigita/ui/admin/GroupSearchAndListModel.java#7 $
 */

class GroupSearchAndListModel implements SearchAndListModel {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/ui/admin/GroupSearchAndListModel.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * A DataQuery used to perform the search
     */

    private DataQuery m_query;

    // Query for group search.

    private static final String GROUP_ID =
        "groupID";
    private static final String GROUP_NAME =
        "name";
    private static final String RETRIEVE_GROUPS =
        "com.arsdigita.kernel.RetrieveGroups";

    // Group to exclude from the search

    private BigDecimal m_excludedGroupID;

    /**
     * Specify the query to use for searching the groups table.
     *
     * @param query is a String that specifies what to search for.
     */

    public void setQuery (String query) {
        StringBuffer sb = new StringBuffer();
        sb.append("searchName like lower('%");
        sb.append(Utilities.prepare(query));
        sb.append("%')");

        Session session = SessionManager.getSession();
        m_query = session.retrieveQuery(RETRIEVE_GROUPS);
        m_query.addFilter(sb.toString());

        if (m_excludedGroupID != null) {
            m_query.addFilter("groupID != " + m_excludedGroupID);
        }
    }

    /**
     * This defines a group to be excluded from the search.
     */

    public void setExcludedGroupID(BigDecimal id) {
        m_excludedGroupID = id;
    }

    /**
     * Get the key (groupID) for the current element.
     */

    public String getKey() {
        return m_query == null ? null : m_query.get(GROUP_ID).toString();
    }

    /**
     * Get one element from the search result set
     */

    public Object getElement() {
        return m_query == null ? null : m_query.get(GROUP_NAME);
    }

    /**
     * Iterate to the next result of the query.  Returns true if there
     * are more results to process.
     */

    public boolean next() {

        if (m_query == null) {
            return false;
        }

        // Once this result set reaches the end, you need to set
        // m_query = null, otherwise you will get an exception.

        boolean ret = m_query.next();

        if (ret == false) {
            m_query = null;
        }

        return ret;
    }
}
