/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.ui.admin;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.globalization.GlobalizedMessage;

/**
 * A Simple context bar for site wide admin.
 *
 * @deprecated User DimensionalNavbar in com.arsdigita.bebop.DimensionalNavbar
 * @author David Dao
 * @version $Id: //core-platform/dev/src/com/arsdigita/ui/admin/ContextBar.java#9 $ $DateTime: 2004/04/07 16:07:11 $
 * @since
 */

public class ContextBar extends BoxPanel implements AdminConstants {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/ui/admin/ContextBar.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    // String catalog
    private static final GlobalizedMessage WORKSPACE =
        new GlobalizedMessage("ui.admin.contextBar.workspace", BUNDLE_NAME);
    private static final GlobalizedMessage HOME      =
        new GlobalizedMessage("ui.admin.contextBar.home", BUNDLE_NAME);
    private static final GlobalizedMessage SEPARATOR =
        new GlobalizedMessage("ui.admin.contextBar.Separator", BUNDLE_NAME);

    // Site node name.
    private static final GlobalizedMessage SITE_NODE_NAME =
        new GlobalizedMessage("ui.admin.contextBar.siteNode", BUNDLE_NAME);

    /**
     * Constructor.
     */

    public ContextBar() {
        this(false);
    }

    /**
     * Constructor.
     *
     * @param isFinal determines whether additional elements can be
     * added to the ContextBar, and whether the default final element
     * is a Label or a Link
     */

    public ContextBar(boolean isFinal) {

        super(BoxPanel.HORIZONTAL);

        // Set the class so this element be customized using XSL
        setClassAttr("ContextBar");

        add(new Link(new Label(WORKSPACE), "/pvt/home"));
        add(HOME, "/");

        if (isFinal) {
            add(SITE_NODE_NAME);
        } else {
            add(SITE_NODE_NAME, "/admin/");
        }
    }

    /**
     * Add a link to the ContextBar.  The link will be preceded by a
     * ContextBar.SEPARATOR.
     */

    public void add(String name, String url) {
        add(new Label(SEPARATOR));
        add(new Link(name, url));
    }

    /**
     * Add a simple label to the ContextBar.  The label will be preceeded by a
     * ContextBar.SEPARATOR.
     */

    public void add(String name) {
        add(new Label(SEPARATOR));
        add(new Label(name));
    }

    /**
     * Add a link to the ContextBar.  The link will be preceded by a
     * ContextBar.SEPARATOR.
     */
    public void add(GlobalizedMessage name, String url) {
        add(new Label(SEPARATOR));
        add(new Link(new Label(name), url));
    }

    /**
     * Add a simple label to the ContextBar.  The label will be preceeded by a
     * ContextBar.SEPARATOR.
     */
    public void add(GlobalizedMessage name) {
        add(new Label(SEPARATOR));
        add(new Label(name));
    }
}
