/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.ui;

import com.arsdigita.initializer.Configuration;
import org.apache.log4j.Logger;
import java.util.Iterator;
import java.util.List;

import com.arsdigita.initializer.InitializationException;


public class Initializer implements com.arsdigita.initializer.Initializer {

    private Configuration m_conf = new Configuration();
    private static final Logger s_log =
        Logger.getLogger(Initializer.class);

    public static final String DEFAULT_LAYOUT = "defaultLayout";
    public static final String APPLICATION_LAYOUTS = "applicationLayouts";

    public Initializer() {
        m_conf.initParameter
            (DEFAULT_LAYOUT,
             "The default layout for the SimplePage class",
             List.class);
        m_conf.initParameter
            (APPLICATION_LAYOUTS,
             "The customized layout for applications using the SimplePage class",
             List.class);

    }

    public void startup() throws InitializationException {
        s_log.info("Starting UI initializer");

        List defaultLayout = (List)m_conf.getParameter(DEFAULT_LAYOUT);
        if (defaultLayout != null) {
            s_log.info("Processing default layout");
            SimplePage.setDefaultLayout(buildLayout(defaultLayout));
        }

        List apps = (List)m_conf.getParameter(APPLICATION_LAYOUTS);
        if (apps != null) {
            Iterator i = apps.iterator();
            while (i.hasNext()) {
                List app = (List)i.next();

                String name = (String)app.get(0);
                List layout = (List)app.get(1);

                s_log.info("Processing layout for " + name);

                SimplePage.setLayout(name,
                                     buildLayout(layout));
            }
        }

        s_log.info("UI initializer completed");
    }

    public Configuration getConfiguration() {
        return m_conf;
    }

    public void shutdown() {
        // nada
    }

    private SimplePageLayout buildLayout(List desc) {
        SimplePageLayout layout = new SimplePageLayout();

        Iterator comps = desc.iterator();
        while (comps.hasNext()) {
            List comp = (List)comps.next();

            String position = (String)comp.get(0);
            String className = (String)comp.get(1);
            
            Class classObject;
            try {
                classObject =  Class.forName(className);
            } catch (ClassNotFoundException ex) {
                throw new InitializationException(
                    "cannot find component " + className, ex
                );
            }
            
            s_log.info("Adding " + className + " to " + position);

            layout.addComponent(classObject,
                                position);
        }

        return layout;
    }
}
