/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.toolbox.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormModel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;

/**
 * <p>A simple layout panel with top, bottom, left, right, and body
 * sections.</p>
 *
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/Section.java#9 $
 */
public class Section extends SimpleComponent {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/Section.java#9 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(Section.class);

    private final ArrayList m_children;
    private Component m_heading;
    private Component m_body;

    public Section(final Component heading, final Component body) {
        m_children = new ArrayList(2);
        m_heading = heading;
        m_body = body;
    }

    public Section(final GlobalizedMessage heading, final Component body) {
        this(new Label(heading), body);
    }

    public Section(final Component heading) {
        this(heading, new NullComponent());
    }

    public Section(final GlobalizedMessage heading) {
        this(heading, new NullComponent());
    }

    public Section() {
        this(new NullComponent(), new NullComponent());
    }

    public final void setHeading(final Component heading) {
        Assert.assertNotNull(heading, "Component header");
        Assert.assertNotLocked(this);

        m_heading = heading;
    }

    public final void setHeading(final GlobalizedMessage message) {
        setHeading(new Label(message));
    }

    public final void setBody(final Component body) {
        Assert.assertNotNull(body, "Component body");
        Assert.assertNotLocked(this);

        m_body = body;
    }

    public void register(final Page page) {
        super.register(page);

        m_children.add(m_heading);
        m_children.add(m_body);
    }

    public void register(final Form form, final FormModel model) {
        super.register(form, model);

        m_children.add(m_heading);
        m_children.add(m_body);
    }

    public final Iterator children() {
        return m_children.iterator();
    }

    public final void generateXML(final PageState state, final Element parent) {
        if (isVisible(state)) {
            final Element section = parent.newChildElement
                ("bebop:section", BEBOP_XML_NS);

            final Element heading = section.newChildElement
                ("bebop:heading", BEBOP_XML_NS);

            m_heading.generateXML(state, heading);

            final Element body = section.newChildElement
                ("bebop:body", BEBOP_XML_NS);

            m_body.generateXML(state, body);
        }
    }
}
