/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.toolbox.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RowSequenceBuilder;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.DataQuery;

/** 
 *  Adapter around Session.  A closure fixating the queryName argument
 *  to Session.retrieveQuery */
public class QueryRowsBuilder implements RowSequenceBuilder {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/QueryRowsBuilder.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private String m_typeName = null;

    public QueryRowsBuilder(String typeName) {
        m_typeName = typeName;
    }

    /** Build a row sequence as a DataCollection.  The {@index
     * com.arsdigita.infrastructure.RowSequence} interface mandates a
     * {@index com.arsdigita.bebop.PageState} argument because some
     * builder might use it.  */
    public DataQuery makeRowSequence(PageState state) {
        return SessionManager.getSession().retrieveQuery(m_typeName);
    }
}
