/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.toolbox.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.globalization.Globalized;
import com.arsdigita.kernel.Kernel;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

/**
 *
 * This class holds methods to support consistent formatting across the system.
 *
 * @version $Revision: #10 $ $Date: 2004/04/07 $
 * @version $Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/FormatStandards.java#10 $
 */

public class FormatStandards implements Globalized {
    private static RequestLocal s_dateFormat = new RequestLocal();
    private static RequestLocal s_dateTimeFormat = new RequestLocal();

    private static void initialize(PageState ps) {
        Locale l = Kernel.getContext().getLocale();
        s_dateFormat.set(ps, DateFormat.getDateInstance
                         (DATE_DISPLAY_FORMAT, l));
        s_dateTimeFormat.set(ps, DateFormat.getDateTimeInstance
                             (DATE_DISPLAY_FORMAT, TIME_DISPLAY_FORMAT, l));
    }

    /**
     * @return A globalized DateFormat instance for formatting the date only.
     * @see #getDateTimeFormat()
     */
    public static DateFormat getDateFormat() {
        PageState ps = PageState.getPageState();
        Object obj = s_dateFormat.get(ps);

        if (obj == null) {
            initialize(ps);
            obj = s_dateFormat.get(ps);
        }

        return (DateFormat) obj;
    }

    /**
     * @return A globalized DateFormat instance for formatting the date and time.
     * @see #getDateFormat()
     */
    public static DateFormat getDateTimeFormat() {
        PageState ps = PageState.getPageState();
        Object obj = s_dateTimeFormat.get(ps);

        if (obj == null) {
            initialize(ps);
            obj = s_dateTimeFormat.get(ps);
        }

        return (DateFormat) obj;
    }

    /**
     * Formats a date value according to formatting standards and localization.
     * In English This will show the date as "Mmm DD, YYYY" or "Jan 23, 2002."
     * This method discards the clock time.
     *
     * @param d The date to format.
     * @return A properly formatted date.
     * @see #formatDateTime(Date)
     */
    public static String formatDate(Date d) {
        return (d == null) ? null : getDateFormat().format(d);
    }

    /**
     * Formats a date and time value according to formatting
     * standards and localization.
     * This method includes the date and the time.
     * In English, it will appear
     * as "Mmm DD, YYYY HH:MM AM" or "Jan 23, 2002, 5:44 PM.
     *
     * @param d The date to format.
     * @return A properly formatted date and time.
     */
    public static String formatDateTime(Date d) {
        return (d == null) ? null : getDateTimeFormat().format(d);
    }
}
